/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.bookmark;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.TreeItem;
import zigen.plugin.db.ui.bookmark.TreeLeafListTransfer;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.BookmarkFolder;
import zigen.plugin.db.ui.internal.BookmarkRoot;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;

public class DropBookmarkAdapter
extends DropTargetAdapter {
    TreeViewer viewer;
    IStructuredSelection selection;

    public DropBookmarkAdapter(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void dragOver(DropTargetEvent e) {
        this.setEventDetail(e);
        e.feedback = 25;
    }

    public void dropAccept(DropTargetEvent e) {
        if (e.item == null) {
            e.detail = 0;
        } else {
            Object obj = ((TreeItem)e.item).getData();
            e.detail = obj instanceof TreeLeaf ? (obj instanceof BookmarkRoot || obj instanceof BookmarkFolder ? 2 : 0) : 0;
            this.setEventDetail(e);
        }
    }

    private void setEventDetail(DropTargetEvent e) {
        if (e.item == null) {
            e.detail = 0;
            return;
        }
        if (!(e.item instanceof TreeItem)) {
            e.detail = 0;
            return;
        }
        if (!(e.item.getData() instanceof TreeNode)) {
            e.detail = 0;
            return;
        }
        Object target = ((TreeItem)e.item).getData();
        Iterator iter = this.selection.iterator();
        while (iter.hasNext()) {
            TreeLeaf leaf = (TreeLeaf)iter.next();
            if (!(leaf instanceof Bookmark) && !(leaf instanceof BookmarkFolder)) {
                e.detail = 0;
                return;
            }
            if (leaf.equals((TreeLeaf)target)) {
                e.detail = 0;
                return;
            }
            if (!this.isMyChild(leaf, (TreeLeaf)target)) continue;
            e.detail = 0;
            return;
        }
        e.detail = target instanceof BookmarkRoot || target instanceof BookmarkFolder ? 2 : 0;
    }

    private boolean isMyChild(TreeLeaf parent, TreeLeaf target) {
        if (target.getParent() == null) {
            return false;
        }
        TreeNode wkParent = target.getParent();
        if (parent.equals(wkParent)) {
            return true;
        }
        return this.isMyChild(parent, wkParent);
    }

    public void dragEnter(DropTargetEvent e) {
        this.selection = (IStructuredSelection)this.viewer.getSelection();
        if (e.detail == 16) {
            e.detail = 2;
        }
    }

    public void dragOperationChanged(DropTargetEvent e) {
        if (e.detail == 16) {
            e.detail = 2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drop(DropTargetEvent e) {
        if (e.data == null) {
            e.detail = 0;
            return;
        }
        Object obj = ((TreeItem)e.item).getData();
        if (!(obj instanceof TreeNode)) throw new IllegalArgumentException("UnExpected Object. " + obj.getClass().getName());
        TreeNode target = (TreeNode)obj;
        if (!TreeLeafListTransfer.getInstance().isSupportedType(e.currentDataType)) throw new RuntimeException("UnExpected Error.");
        TreeLeaf[] leafs = (TreeLeaf[])e.data;
        int i = 0;
        while (i < leafs.length) {
            TreeLeaf leaf = leafs[i];
            target.addChild(leaf);
            this.viewer.expandToLevel((Object)leaf, 1);
            ++i;
        }
        this.viewer.refresh((Object)target);
    }
}

