/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.dialogs;

import java.io.File;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;

public class DriverContentProvider
implements ITreeContentProvider {
    private Root invisibleRoot;
    Table[] tables = null;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput != null) {
            this.invisibleRoot = new Root("invisible", true);
            IDBConfig[] dbConfigs = DBConfigManager.getDBConfigs();
            int i = 0;
            while (i < dbConfigs.length) {
                IDBConfig config = dbConfigs[i];
                DataBase wk_db = new DataBase();
                wk_db.setName(config.getDriverName());
                DataBase node = (DataBase)this.invisibleRoot.getChild(wk_db.getName());
                if (node == null) {
                    this.invisibleRoot.addChild(wk_db);
                    node = wk_db;
                }
                String[] classPaths = config.getClassPaths();
                int j = 0;
                while (j < classPaths.length) {
                    TreeLeaf wk;
                    String path = classPaths[j];
                    File file = new File(path);
                    TreeLeaf classPath = null;
                    if (file.exists() && (wk = node.getChild((classPath = file.isDirectory() ? new Folder(path) : new TreeLeaf(path)).getName())) == null) {
                        node.addChild(classPath);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(this.invisibleRoot);
    }

    public Object getParent(Object element) {
        if (element instanceof TreeLeaf) {
            return ((TreeLeaf)element).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeNode) {
            return ((TreeNode)parentElement).getChildrens();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).hasChildren();
        }
        return false;
    }

    public Root getInvisibleRoot() {
        return this.invisibleRoot;
    }
}

