/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.sql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;
import zigen.plugin.db.ui.internal.OracleSource;

public class SourceEditorInput
implements IStorageEditorInput,
IEditorInput {
    private String tooltip;
    private String name;
    private IDBConfig config;
    private OracleSourceDetailInfo sourceDetailInfo;
    private OracleSourceErrorInfo[] sourceErrorInfos;
    private OracleSource oracleSource;

    public SourceEditorInput(IDBConfig config, OracleSource source, OracleSourceDetailInfo sourceDetailInfo, OracleSourceErrorInfo[] sourceErrorInfos) {
        this.config = config;
        this.oracleSource = source;
        this.sourceDetailInfo = sourceDetailInfo;
        this.sourceErrorInfos = sourceErrorInfos;
        this.name = String.valueOf(sourceDetailInfo.getName()) + "[" + sourceDetailInfo.getType() + "]";
        this.tooltip = String.valueOf(sourceDetailInfo.getName()) + "[" + sourceDetailInfo.getType() + "]";
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SourceEditorInput) {
            SourceEditorInput input = (SourceEditorInput)o;
            if (this.config.getDbName().equals(input.config.getDbName())) {
                return this.name.equals(input.getName());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public IDBConfig getConfig() {
        return this.config;
    }

    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
    }

    public OracleSourceErrorInfo[] getSourceErrorInfos() {
        return this.sourceErrorInfos;
    }

    public OracleSourceDetailInfo getSourceDetailInfo() {
        return this.sourceDetailInfo;
    }

    public IStorage getStorage() throws CoreException {
        return this.createStore();
    }

    private IStorage createStore() {
        return new IStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return false;
            }

            public String getName() {
                return null;
            }

            public IPath getFullPath() {
                return null;
            }

            public InputStream getContents() throws CoreException {
                String encoding = ResourcesPlugin.getEncoding();
                byte[] bytes = new byte[]{};
                if (SourceEditorInput.this.sourceDetailInfo != null) {
                    try {
                        bytes = SourceEditorInput.this.sourceDetailInfo.getText().getBytes(encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        bytes = SourceEditorInput.this.sourceDetailInfo.getText().getBytes();
                    }
                }
                return new ByteArrayInputStream(bytes);
            }
        };
    }

    public OracleSource getOracleSource() {
        return this.oracleSource;
    }
}

