/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.TransactionForTableEditor;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;

public class DisconnectDBJob
extends AbstractJob {
    private TreeViewer viewer;
    private DataBase db;

    public DisconnectDBJob(TreeViewer viewer, DataBase db) {
        super("Disconnect Database");
        this.viewer = viewer;
        this.db = db;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.db.setEnabled(false);
            Transaction trans = Transaction.getInstance(this.db.getDbConfig());
            trans.cloesConnection();
            TransactionForTableEditor trans2 = TransactionForTableEditor.getInstance(this.db.getDbConfig());
            trans2.cloesConnection();
            if (DBType.getType(this.db.getDbConfig()) == 6) {
                this.shutdown(this.db.getDbConfig());
            }
            this.db.removeChildAll();
            this.db.setConnected(false);
            this.db.setExpanded(false);
            this.db.setEnabled(true);
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.db, 0));
        }
        catch (Exception e) {
            this.showErrorMessage("Failed disconnect database", e);
        }
        return Status.OK_STATUS;
    }

    private void shutdown(IDBConfig config) {
        try {
            ConnectionManager.shutdown(config);
        }
        catch (SQLException e) {
            if (DBType.getType(config) == 6 && e.getErrorCode() == 50000) {
                this.showMessage(null, e.getMessage());
                return;
            }
            this.showErrorMessage(e.getMessage(), e);
        }
        catch (Exception e) {
            this.showErrorMessage(e.getMessage(), e);
        }
    }
}

