/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.SQLHistory;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.ui.internal.History;
import zigen.plugin.db.ui.internal.HistoryDataBaseFolder;
import zigen.plugin.db.ui.internal.HistoryFolder;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;

public class HistoryContentProvider
implements ITreeContentProvider {
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SQLHistoryManager historyMgr = DbPlugin.getDefault().getHistoryManager();
    private Root invisibleRoot;
    private TreeViewer viewer;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)v;
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        if (this.invisibleRoot == null) {
            this.initialize();
        }
        return this.getChildren(this.invisibleRoot);
    }

    public Object getParent(Object element) {
        if (element instanceof TreeLeaf) {
            return ((TreeLeaf)element).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeNode) {
            return ((TreeNode)parentElement).getChildrens();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).hasChildren();
        }
        return false;
    }

    public void initialize() {
        this.invisibleRoot = new Root("invisible", true);
        this.addElement();
    }

    public void addElement() {
        TimeWatcher tw = new TimeWatcher();
        tw.start();
        List historys = this.historyMgr.getHistory();
        Iterator iter = historys.iterator();
        while (iter.hasNext()) {
            SQLHistory element = (SQLHistory)iter.next();
            HistoryFolder folder = new HistoryFolder(element.getDate());
            new HistoryDataBaseFolder(element.getConfig());
            History history = new History(element);
            String sql = history.getName();
            if ("".equals(sql)) continue;
            TreeNode node = (TreeNode)this.invisibleRoot.getChild(folder.getName());
            if (node == null) {
                this.invisibleRoot.addChild(folder);
                node = folder;
            }
            if (!(node instanceof HistoryFolder)) continue;
            HistoryFolder f = (HistoryFolder)node;
            f.addChild(history);
        }
        tw.stop();
    }

    public HistoryFolder getHistoryHolder(Date date) {
        if (this.invisibleRoot == null) {
            return null;
        }
        HistoryFolder wk = new HistoryFolder(date);
        TreeLeaf node = this.invisibleRoot.getChild(wk.getName());
        if (node instanceof HistoryFolder) {
            return (HistoryFolder)node;
        }
        return null;
    }

    public void reflesh(SQLHistory newHistory) {
        List sqlHistorys = this.historyMgr.getHistory();
        List folders = this.invisibleRoot.getChildren();
        int i = 0;
        while (i < folders.size()) {
            HistoryFolder folder = (HistoryFolder)folders.get(i);
            List historys = folder.getChildren();
            int k = 0;
            while (k < historys.size()) {
                History history = (History)historys.get(k);
                if (!sqlHistorys.contains(history.getSqlHistory())) {
                    folder.removeChild(history);
                    if (folder.getChildren().size() == 0) {
                        this.invisibleRoot.removeChild(folder);
                        folders.remove(folders);
                        --i;
                    }
                }
                ++k;
            }
            ++i;
        }
        History h = new History(newHistory);
        HistoryFolder current = this.getHistoryHolder(newHistory.getDate());
        if (current != null) {
            current.addChild(h);
        } else {
            HistoryFolder folder = new HistoryFolder(newHistory.getDate());
            this.invisibleRoot.addChild(folder);
            folder.addChild(h);
        }
        this.viewer.refresh();
    }

    public Root getInvisibleRoot() {
        return this.invisibleRoot;
    }
}

