/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.csv;

import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableManager;
import zigen.plugin.db.csv.CSVConfig;
import zigen.plugin.db.csv.CSVWriter;
import zigen.plugin.db.csv.Messages;
import zigen.plugin.db.ui.internal.ITable;

public class CreateCSVAction
extends Action {
    private StructuredViewer viewer = null;
    private IPreferenceStore store;

    public CreateCSVAction(StructuredViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("CreateCSVAction.0"));
        this.setToolTipText(Messages.getString("CreateCSVAction.1"));
        this.store = DbPlugin.getDefault().getPreferenceStore();
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object element = selection.getFirstElement();
        this.invoke(element);
    }

    private void invoke(Object element) {
        if (element instanceof ITable) {
            ITable table = (ITable)element;
            try {
                Shell shell = DbPlugin.getDefault().getShell();
                FileDialog dialog = new FileDialog(shell, 8192);
                dialog.setFileName(table.getName());
                dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                dialog.setFilterNames(new String[]{Messages.getString("CreateCSVAction.4"), Messages.getString("CreateCSVAction.5")});
                String fileName = dialog.open();
                if (fileName == null) {
                    return;
                }
                File csvFile = new File(fileName);
                if (csvFile.exists()) {
                    MessageBox msg = new MessageBox(shell, 196);
                    msg.setMessage(String.valueOf(fileName) + Messages.getString("CreateCSVAction.6"));
                    msg.setText(Messages.getString("CreateCSVAction.7"));
                    int res2 = msg.open();
                    if (res2 == 128) {
                        return;
                    }
                }
                CSVConfig config = new CSVConfig();
                String encoding = this.store.getString("CSVPreferencePage.Encoding");
                String separator = this.store.getString("CSVPreferencePage.Demiliter");
                boolean nonHeader = this.store.getBoolean("CSVPreferencePage.NonHeader");
                boolean nonDoubleQuate = this.store.getBoolean("CSVPreferencePage.NonDoubleQuate");
                config.setQuery(TableManager.getSQLForCSV(table));
                config.setCsvEncoding(encoding);
                config.setSeparator(separator);
                config.setNonHeader(nonHeader);
                config.setNonDoubleQuate(nonDoubleQuate);
                config.setCsvFile(fileName);
                CSVWriter writer = new CSVWriter(table.getDbConfig(), config);
                writer.execute();
            }
            catch (Exception e) {
                DbPlugin.getDefault().showErrorDialog(e);
            }
        }
    }
}

