/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.diff.DDLDiffForSchemaJob;
import zigen.plugin.db.diff.Messages;
import zigen.plugin.db.ui.internal.Schema;

public class DDLDiffForSchemaAction
extends Action
implements Runnable {
    private boolean showDialog = true;
    private TreeViewer viewer = null;
    private Schema left = null;
    private Schema right = null;

    public DDLDiffForSchemaAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("DDLDiffForSchemaAction.0"));
        this.setToolTipText(Messages.getString("DDLDiffForSchemaAction.1"));
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        try {
            int index = 0;
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof Schema)) continue;
                Schema schema = (Schema)obj;
                if (index == 0) {
                    this.left = schema;
                    ++index;
                    continue;
                }
                if (index != 1) break;
                this.right = schema;
                ++index;
            }
            if (index == 2) {
                DDLDiffForSchemaJob job = new DDLDiffForSchemaJob(this.viewer, this.left, this.right);
                job.setPriority(20);
                job.setUser(this.showDialog);
                job.schedule();
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

