/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DropSQLInvoker;
import zigen.plugin.db.ext.oracle.internal.OracleSequenceInfo;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.editors.sql.SequenceEditorInput;
import zigen.plugin.db.ui.editors.sql.SourceEditorInput;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.TreeNode;

public class DropTreeNodeAction
extends Action
implements Runnable {
    StructuredViewer viewer = null;

    public DropTreeNodeAction(StructuredViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("DropTreeNodeAction.0"));
        this.setToolTipText(Messages.getString("DropTreeNodeAction.1"));
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void run() {
        try {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                String name;
                String type;
                String owner;
                Schema schema;
                TreeNode parent;
                TreeNode elem;
                Object obj = iter.next();
                if (obj instanceof OracleSource) {
                    elem = (OracleSource)obj;
                    parent = elem.getParent();
                    schema = elem.getSchema();
                    owner = schema.getName();
                    type = ((OracleSource)elem).getType();
                    name = ((OracleSource)elem).getName();
                    if (!DbPlugin.getDefault().confirmDialog(String.valueOf(name) + Messages.getString("DropTreeNodeAction.2") + type + Messages.getString("DropTreeNodeAction.3"))) continue;
                    DropSQLInvoker.execute(elem.getDbConfig(), owner, type, name);
                    parent.removeChild(elem);
                    this.viewer.refresh((Object)parent);
                    this.closeEditor(obj);
                    continue;
                }
                if (!(obj instanceof OracleSequence)) continue;
                elem = (OracleSequence)obj;
                parent = elem.getParent();
                schema = elem.getSchema();
                owner = schema.getName();
                type = "SEQUENCE";
                name = ((OracleSequence)elem).getName();
                if (!DbPlugin.getDefault().confirmDialog(String.valueOf(name) + Messages.getString("DropTreeNodeAction.5") + type + Messages.getString("DropTreeNodeAction.6"))) continue;
                DropSQLInvoker.execute(elem.getDbConfig(), owner, type, name);
                parent.removeChild(elem);
                this.viewer.refresh((Object)parent);
                this.closeEditor(obj);
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private void closeEditor(Object obj) throws PartInitException {
        ArrayList<IEditorReference> target = new ArrayList<IEditorReference>();
        IEditorReference[] references = DbPlugin.getDefault().getPage().getEditorReferences();
        int i = 0;
        while (i < references.length) {
            OracleSource source;
            IEditorReference reference = references[i];
            IEditorInput input = reference.getEditorInput();
            if (input instanceof SequenceEditorInput) {
                OracleSequenceInfo info = ((SequenceEditorInput)input).getSequenceInfo();
                if (info.equals(obj)) {
                    target.add(reference);
                }
            } else if (input instanceof SourceEditorInput && (source = ((SourceEditorInput)input).getOracleSource()).equals(obj)) {
                target.add(reference);
            }
            ++i;
        }
        if (target.size() > 0) {
            DbPlugin.getCloseEditors(target.toArray(new IEditorReference[0]));
        }
    }
}

