/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.internal;

import java.util.ArrayList;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.ui.internal.BookmarkFolder;
import zigen.plugin.db.ui.internal.BookmarkRoot;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.Synonym;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.internal.View;

public class Bookmark
extends TreeNode
implements ITable {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_TABLE = 0;
    public static final int TYPE_VIEW = 1;
    public static final int TYPE_SYNONYM = 2;
    protected IDBConfig dbConfig;
    protected DataBase dataBase;
    protected Schema schema;
    protected Table table;
    protected Folder folder;
    protected int type;
    boolean isEnabled = false;

    public Bookmark() {
    }

    public void copy(Table original) {
        this.name = new String(original.getName());
        this.dataBase = (DataBase)original.getDataBase().clone();
        this.dbConfig = this.dataBase.getDbConfig();
        if (original.getSchema() != null) {
            this.schema = (Schema)original.getSchema().clone();
            this.schema.setParent(this.dataBase);
            this.folder = (Folder)original.getFolder().clone();
            this.folder.setParent(this.schema);
            this.table = (Table)original.clone();
            this.table.setParent(this.folder);
        } else {
            this.folder = (Folder)original.getFolder().clone();
            this.folder.setParent(this.dataBase);
            this.table = (Table)original.clone();
            this.table.setParent(this.folder);
        }
        this.type = original instanceof Synonym ? 2 : (original instanceof View ? 1 : 0);
    }

    public Bookmark(Table table) {
        this.copy(table);
        this.isEnabled = false;
    }

    public void update(Table table) {
        this.table.update(table);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private Column[] convertColumns(TreeLeaf[] leafs) {
        ArrayList<Column> list = new ArrayList<Column>(leafs.length);
        int i = 0;
        while (i < leafs.length) {
            if (leafs[i] instanceof Column) {
                list.add((Column)leafs[i]);
            }
            ++i;
        }
        return list.toArray(new Column[0]);
    }

    public Column[] getColumns() {
        return this.convertColumns(this.getChildrens());
    }

    public String getLabel() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (this.table.getRemarks() != null && this.table.getRemarks().length() > 0) {
            sb.append(" [");
            sb.append(this.table.getRemarks());
            sb.append("]");
        }
        return sb.toString();
    }

    public String getRemarks() {
        if (this.table != null) {
            return this.table.getRemarks();
        }
        return null;
    }

    public String getSchemaName() {
        if (this.schema != null) {
            return this.schema.getName();
        }
        return null;
    }

    public String getEnclosedName() {
        return SQLUtil.enclose(this.name, this.getDataBase().getEncloseChar());
    }

    public String getSqlTableName() {
        StringBuffer sb = new StringBuffer();
        if (this.getDataBase().isSchemaSupport()) {
            sb.append(this.getSchema().getEscapedName());
            sb.append(".");
            sb.append(this.getEnclosedName());
        } else {
            sb.append(this.getEnclosedName());
        }
        return sb.toString();
    }

    public boolean isSchemaSupport() {
        return this.dataBase.isSchemaSupport();
    }

    public ITable getTable() {
        return this.table;
    }

    public void setTable(ITable table) {
        this.table = table instanceof Table ? (Table)table : null;
    }

    public DataBase getDataBase() {
        return this.dataBase;
    }

    public void setDataBase(DataBase dataBase) {
        this.dataBase = dataBase;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public void setFolder(Folder folder) {
        this.folder = folder;
    }

    public IDBConfig getDbConfig() {
        return this.dbConfig;
    }

    public void setDbConfig(IDBConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    public BookmarkRoot getBookmarkRoot() {
        return this.getBookmarkRoot(this);
    }

    public BookmarkFolder getBookmarkFolder() {
        return this.getBookmarkFolder(this);
    }

    private BookmarkRoot getBookmarkRoot(TreeLeaf leaf) {
        if (leaf instanceof BookmarkRoot) {
            return (BookmarkRoot)leaf;
        }
        if (leaf.getParent() != null) {
            return this.getBookmarkRoot(leaf.getParent());
        }
        throw new IllegalStateException("getBookmarkRoot#BookmarkRoot");
    }

    private BookmarkFolder getBookmarkFolder(TreeLeaf leaf) {
        if (leaf instanceof BookmarkFolder) {
            return (BookmarkFolder)leaf;
        }
        if (leaf.getParent() != null) {
            return this.getBookmarkFolder(leaf.getParent());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Bookmark castedObj = (Bookmark)o;
        return (this.dbConfig == null ? castedObj.dbConfig == null : this.dbConfig.equals(castedObj.dbConfig)) && (this.dataBase == null ? castedObj.dataBase == null : this.dataBase.equals(castedObj.dataBase)) && (this.schema == null ? castedObj.schema == null : this.schema.equals(castedObj.schema)) && (this.table == null ? castedObj.table == null : this.table.equals(castedObj.table));
    }

    public TableFKColumn[] getTableFKColumns() {
        if (this.table != null) {
            return this.table.getTableFKColumns();
        }
        return null;
    }

    public TablePKColumn[] getTablePKColumns() {
        if (this.table != null) {
            return this.table.getTablePKColumns();
        }
        return null;
    }

    public TableIDXColumn[] getTableUIDXColumns() {
        if (this.table != null) {
            return this.table.getTableUIDXColumns();
        }
        return null;
    }

    public TableIDXColumn[] getTableNonUIDXColumns() {
        if (this.table != null) {
            return this.table.getTableNonUIDXColumns();
        }
        return null;
    }

    public void setTableFKColumns(TableFKColumn[] tableFKColumns) {
        this.table.setTableFKColumns(tableFKColumns);
    }

    public void setTablePKColumns(TablePKColumn[] tablePKColumns) {
        this.table.setTablePKColumns(tablePKColumns);
    }

    public void setTableUIDXColumns(TableIDXColumn[] tableUIDXColumns) {
        this.table.setTableUIDXColumns(tableUIDXColumns);
    }

    public void setTableNonUIDXColumns(TableIDXColumn[] tableNonUIDXColumns) {
        this.table.setTableNonUIDXColumns(tableNonUIDXColumns);
    }

    public String getFolderName() {
        if (this.folder == null) {
            if (this.type == 0) {
                return "TABLE";
            }
            if (this.type == 1) {
                return "VIEW";
            }
            if (this.type == 2) {
                return "SYNONYM";
            }
            return "TABLE";
        }
        return this.folder.getName();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[Bookmark:");
        buffer.append(" dbConfig: ");
        buffer.append(this.dbConfig);
        buffer.append(" dataBase: ");
        buffer.append(this.dataBase);
        buffer.append(" schema: ");
        buffer.append(this.schema);
        buffer.append(" table: ");
        buffer.append(this.table);
        buffer.append(" folder: ");
        buffer.append(this.folder);
        buffer.append(" type: ");
        buffer.append(this.type);
        buffer.append("]");
        return buffer.toString();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean b) {
        this.isEnabled = b;
    }

    public boolean isSynonym() {
        return this.type == 2;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setRemarks(String remarks) {
        if (this.table != null) {
            this.table.setRemarks(remarks);
        }
    }

    public TableConstraintColumn[] getTableConstraintColumns() {
        return this.table.getTableConstraintColumns();
    }

    public void setTableConstraintColumns(TableConstraintColumn[] tableConstraintColumns) {
        this.table.setTableConstraintColumns(tableConstraintColumns);
    }
}

