/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.csv.CreateCSVForTableAction;
import zigen.plugin.db.csv.CreateCSVForTableWithConditionAction;
import zigen.plugin.db.ui.actions.CopyInsertStatementAction;
import zigen.plugin.db.ui.actions.CopyRecordDataAction;
import zigen.plugin.db.ui.actions.CopyRecordTrimDataAction;
import zigen.plugin.db.ui.actions.DeleteRecordAction;
import zigen.plugin.db.ui.actions.InsertRecordAction;
import zigen.plugin.db.ui.actions.PasteRecordDataAction;
import zigen.plugin.db.ui.actions.SelectAllRecordAction;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.internal.action.AddCheckAction;
import zigen.plugin.db.ui.editors.internal.action.AddColumnAction;
import zigen.plugin.db.ui.editors.internal.action.AddForeginKeyAction;
import zigen.plugin.db.ui.editors.internal.action.AddIndexAction;
import zigen.plugin.db.ui.editors.internal.action.AddPrimaryKeyAction;
import zigen.plugin.db.ui.editors.internal.action.AddUniqueKeyAction;
import zigen.plugin.db.ui.editors.internal.action.DropColumnAction;
import zigen.plugin.db.ui.editors.internal.action.DropConstraintAction;
import zigen.plugin.db.ui.editors.internal.action.DropIndexAction;
import zigen.plugin.db.ui.editors.internal.action.DuplicateColumnAction;
import zigen.plugin.db.ui.editors.internal.action.EditColumnAction;
import zigen.plugin.db.ui.editors.internal.action.OpenTriggerAction;
import zigen.plugin.db.ui.internal.Constraint;
import zigen.plugin.db.ui.internal.ConstraintRoot;
import zigen.plugin.db.ui.internal.Index;
import zigen.plugin.db.ui.internal.IndexRoot;
import zigen.plugin.db.ui.internal.Trigger;

public class TableViewerContributor
extends MultiPageEditorActionBarContributor {
    private InsertRecordAction insertRecordAction = new InsertRecordAction();
    private DeleteRecordAction deleteRecordAction;
    private SelectAllRecordAction selectAllAction;
    private CopyRecordDataAction copyRecordDataAction;
    private PasteRecordDataAction pasteRecordAction;
    private CreateCSVForTableAction createCSVAction;
    private CreateCSVForTableWithConditionAction createCSV2Action;
    private CopyInsertStatementAction copyStringInsertStatementAction;
    private AddColumnAction addColumnAction;
    private DuplicateColumnAction duplicateColumnAction;
    private EditColumnAction editColumnAction;
    private DropColumnAction deleteColumnAction;
    private AddPrimaryKeyAction addPrimaryKeyAction;
    private AddForeginKeyAction addForeginKeyAction;
    private AddUniqueKeyAction addUniqueKeyAction;
    private AddCheckAction addCheckAction;
    private AddIndexAction addIndexAction;
    private DropIndexAction dropIndexAction;
    private DropConstraintAction dropConstraintAction;
    private OpenTriggerAction openTriggerAction;
    protected CopyRecordTrimDataAction copyTrimAction;
    private IDBConfig config;

    public TableViewerContributor() {
        this.insertRecordAction.setEnabled(false);
        this.deleteRecordAction = new DeleteRecordAction();
        this.selectAllAction = new SelectAllRecordAction();
        this.copyRecordDataAction = new CopyRecordDataAction();
        this.copyStringInsertStatementAction = new CopyInsertStatementAction();
        this.pasteRecordAction = new PasteRecordDataAction();
        this.createCSVAction = new CreateCSVForTableAction();
        this.createCSV2Action = new CreateCSVForTableWithConditionAction();
        this.addColumnAction = new AddColumnAction();
        this.editColumnAction = new EditColumnAction();
        this.duplicateColumnAction = new DuplicateColumnAction();
        this.deleteColumnAction = new DropColumnAction();
        this.addPrimaryKeyAction = new AddPrimaryKeyAction();
        this.addForeginKeyAction = new AddForeginKeyAction();
        this.addUniqueKeyAction = new AddUniqueKeyAction();
        this.addCheckAction = new AddCheckAction();
        this.addIndexAction = new AddIndexAction();
        this.dropIndexAction = new DropIndexAction();
        this.dropConstraintAction = new DropConstraintAction();
        this.copyTrimAction = new CopyRecordTrimDataAction();
        this.openTriggerAction = new OpenTriggerAction();
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
    }

    public void fillContextMenu(IMenuManager manager) {
        this.reflesh();
        manager.add((IAction)this.insertRecordAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyRecordDataAction);
        manager.add((IAction)this.copyTrimAction);
        manager.add((IAction)this.pasteRecordAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.deleteRecordAction);
        manager.add((IAction)this.selectAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyStringInsertStatementAction);
        manager.add((IAction)this.createCSVAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void fillContextMenuForDDL(IMenuManager manager) {
        this.reflesh();
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void fillContextMenuForDefine(IMenuManager manager, ISelection selection) {
        ((StructuredSelection)selection).getFirstElement();
        manager.add((IAction)this.addColumnAction);
        manager.add((IAction)this.editColumnAction);
        manager.add((IAction)this.deleteColumnAction);
        manager.add((IAction)this.duplicateColumnAction);
        switch (DBType.getType(this.config)) {
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                this.addColumnAction.setEnabled(true);
                this.editColumnAction.setEnabled(true);
                this.deleteColumnAction.setEnabled(true);
                break;
            }
            case 10: {
                this.addColumnAction.setEnabled(true);
                this.editColumnAction.setEnabled(false);
                this.deleteColumnAction.setEnabled(false);
                break;
            }
            default: {
                this.addColumnAction.setEnabled(false);
                this.editColumnAction.setEnabled(false);
                this.deleteColumnAction.setEnabled(false);
                this.duplicateColumnAction.setEnabled(false);
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void fillContextMenuForConstraints(IMenuManager manager, ISelection selection) {
        Object obj = ((StructuredSelection)selection).getFirstElement();
        switch (DBType.getType(this.config)) {
            case 1: {
                if (obj instanceof ConstraintRoot) {
                    this.dropConstraintAction.setEnabled(false);
                    manager.add((IAction)this.addPrimaryKeyAction);
                    manager.add((IAction)this.addForeginKeyAction);
                    manager.add((IAction)this.addUniqueKeyAction);
                    manager.add((IAction)this.addCheckAction);
                    manager.add((IAction)this.dropConstraintAction);
                    break;
                }
                if (obj instanceof Constraint) {
                    this.dropConstraintAction.setEnabled(true);
                    manager.add((IAction)this.addPrimaryKeyAction);
                    manager.add((IAction)this.addForeginKeyAction);
                    manager.add((IAction)this.addUniqueKeyAction);
                    manager.add((IAction)this.addCheckAction);
                    manager.add((IAction)this.dropConstraintAction);
                    break;
                }
                if (obj instanceof IndexRoot) {
                    this.dropIndexAction.setEnabled(false);
                    manager.add((IAction)this.addIndexAction);
                    manager.add((IAction)this.dropIndexAction);
                    break;
                }
                if (obj instanceof Index) {
                    this.dropIndexAction.setEnabled(true);
                    manager.add((IAction)this.addIndexAction);
                    manager.add((IAction)this.dropIndexAction);
                    break;
                }
                if (!(obj instanceof Trigger)) break;
                manager.add((IAction)this.openTriggerAction);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                if (obj instanceof ConstraintRoot) {
                    this.dropConstraintAction.setEnabled(false);
                    manager.add((IAction)this.addPrimaryKeyAction);
                    manager.add((IAction)this.addForeginKeyAction);
                    manager.add((IAction)this.dropConstraintAction);
                    break;
                }
                if (obj instanceof Constraint) {
                    this.dropConstraintAction.setEnabled(true);
                    manager.add((IAction)this.addPrimaryKeyAction);
                    manager.add((IAction)this.addForeginKeyAction);
                    manager.add((IAction)this.dropConstraintAction);
                    break;
                }
                if (obj instanceof IndexRoot) {
                    this.dropIndexAction.setEnabled(false);
                    manager.add((IAction)this.addIndexAction);
                    manager.add((IAction)this.dropIndexAction);
                    break;
                }
                if (!(obj instanceof Index)) break;
                this.dropIndexAction.setEnabled(true);
                manager.add((IAction)this.addIndexAction);
                manager.add((IAction)this.dropIndexAction);
                break;
            }
            default: {
                if (obj instanceof ConstraintRoot) {
                    manager.add((IAction)this.addPrimaryKeyAction);
                    manager.add((IAction)this.addForeginKeyAction);
                    manager.add((IAction)this.dropConstraintAction);
                } else if (obj instanceof Constraint) {
                    manager.add((IAction)this.addPrimaryKeyAction);
                    manager.add((IAction)this.addForeginKeyAction);
                    manager.add((IAction)this.dropConstraintAction);
                } else if (obj instanceof IndexRoot) {
                    manager.add((IAction)this.addIndexAction);
                    manager.add((IAction)this.dropIndexAction);
                } else if (obj instanceof Index) {
                    manager.add((IAction)this.addIndexAction);
                    manager.add((IAction)this.dropIndexAction);
                }
                this.addPrimaryKeyAction.setEnabled(false);
                this.addForeginKeyAction.setEnabled(false);
                this.addUniqueKeyAction.setEnabled(false);
                this.addCheckAction.setEnabled(false);
                this.dropConstraintAction.setEnabled(false);
                this.addIndexAction.setEnabled(false);
                this.dropIndexAction.setEnabled(false);
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void contributeToToolBar(IToolBarManager manager) {
        super.contributeToToolBar(manager);
    }

    public void contributeToMenu(IMenuManager menu) {
    }

    public void setActivePage(IEditorPart target) {
        this.makeActions(target);
    }

    public void setActiveEditor(IEditorPart target) {
        super.setActiveEditor(target);
        this.makeActions(target);
    }

    private void makeActions(IEditorPart target) {
        if (target instanceof TableViewEditorFor31) {
            TableViewEditorFor31 editor = (TableViewEditorFor31)target;
            this.config = editor.getDBConfig();
            this.selectAllAction.setActiveEditor(editor);
            this.insertRecordAction.setActiveEditor(editor);
            this.deleteRecordAction.setActiveEditor(editor);
            this.copyRecordDataAction.setActiveEditor(editor);
            this.pasteRecordAction.setActiveEditor(editor);
            this.copyStringInsertStatementAction.setActiveEditor(editor);
            this.createCSVAction.setActiveEditor(editor);
            this.createCSV2Action.setActiveEditor(editor);
            this.addColumnAction.setActiveEditor(editor);
            this.editColumnAction.setActiveEditor(editor);
            this.duplicateColumnAction.setActiveEditor(editor);
            this.deleteColumnAction.setActiveEditor(editor);
            this.addPrimaryKeyAction.setActiveEditor(editor);
            this.addForeginKeyAction.setActiveEditor(editor);
            this.addUniqueKeyAction.setActiveEditor(editor);
            this.addCheckAction.setActiveEditor(editor);
            this.addIndexAction.setActiveEditor(editor);
            this.dropIndexAction.setActiveEditor(editor);
            this.dropConstraintAction.setActiveEditor(editor);
            this.copyTrimAction.setActiveEditor(editor);
            this.openTriggerAction.setActiveEditor(editor);
        }
    }

    void reflesh() {
        this.deleteRecordAction.refresh();
        this.copyRecordDataAction.refresh();
        this.pasteRecordAction.refresh();
        this.copyStringInsertStatementAction.refresh();
        this.copyTrimAction.refresh();
    }

    public void dispose() {
        this.selectAllAction.setActiveEditor(null);
        this.insertRecordAction.setActiveEditor(null);
        this.deleteRecordAction.setActiveEditor(null);
        this.copyRecordDataAction.setActiveEditor(null);
        this.pasteRecordAction.setActiveEditor(null);
        this.copyStringInsertStatementAction.setActiveEditor(null);
        this.createCSVAction.setActiveEditor(null);
        this.createCSV2Action.setActiveEditor(null);
        this.addColumnAction.setActiveEditor(null);
        this.editColumnAction.setActiveEditor(null);
        this.duplicateColumnAction.setActiveEditor(null);
        this.deleteColumnAction.setActiveEditor(null);
        this.addPrimaryKeyAction.setActiveEditor(null);
        this.addForeginKeyAction.setActiveEditor(null);
        this.addUniqueKeyAction.setActiveEditor(null);
        this.addCheckAction.setActiveEditor(null);
        this.addIndexAction.setActiveEditor(null);
        this.dropIndexAction.setActiveEditor(null);
        this.dropConstraintAction.setActiveEditor(null);
        this.copyTrimAction.setActiveEditor(null);
        this.openTriggerAction.setActiveEditor(null);
        super.dispose();
    }

    public void setEnabled(boolean enabled) {
        this.insertRecordAction.setEnabled(enabled);
    }

    public InsertRecordAction getInsertRecordAction() {
        return this.insertRecordAction;
    }

    public DeleteRecordAction getDeleteRecordAction() {
        return this.deleteRecordAction;
    }
}

