/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSequenceInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSequenceSearcher;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;

public class OracleSequeceSearchJob
extends AbstractJob {
    private TreeViewer viewer;
    private Folder folder;

    public OracleSequeceSearchJob(TreeViewer viewer, Folder folder) {
        super(Messages.getString("OracleSequeceSearchJob.0"));
        this.viewer = viewer;
        this.folder = folder;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Search Oracle Seuence...", 10);
            Connection con = Transaction.getInstance(this.folder.getDbConfig()).getConnection();
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.folder.removeChildAll();
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.folder));
            Schema schema = (Schema)this.folder.getParent();
            String owner = schema.getName();
            OracleSequenceInfo[] infos = OracleSequenceSearcher.execute(con, owner);
            this.addSequences(con, this.folder, infos);
            this.folder.setExpanded(true);
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.folder, 0));
            monitor.done();
        }
        catch (Exception e) {
            this.folder.setExpanded(false);
            this.showErrorMessage(Messages.getString("OracleSequeceSearchJob.1"), e);
        }
        return Status.OK_STATUS;
    }

    private void addSequences(Connection con, Folder folder, OracleSequenceInfo[] infos) throws Exception {
        int i = 0;
        while (i < infos.length) {
            OracleSequence seq = new OracleSequence();
            seq.setOracleSequenceInfo(infos[i]);
            folder.addChild(seq);
            ++i;
        }
    }
}

