#
# dcast: Setting PATH of commands and files

require 'readline'
require 'fileutils'

class Path
  def initialize()
    filename = "./path.conf"
    if !FileTest.exist?(filename)
      puts "No exists " + filename + "!!"
      exit 1
    end

    open(filename, "r"){|io|
      while line = io.gets
        key = line.split(/=/)[0].to_s.strip
        value = line.split(/=/)[1].to_s.strip

        case key
        when "dhcp" then
          @dhcp = value.chomp.split[0]
        when "dhcp_i" then #network interface
          @dhcp_i = value.chomp.split[0]
        when "pxe" then
          @pxe = value.chomp.split[0]
        when "mpich" then
          @mpich = value.chomp.split[0]
        when "pxe_kernel" then
          @pxe_kernel = value.chomp.split[0]
        when "kernel" then
          @kernel = value.chomp.split[0]
          @kernel = "/boot/vmlinuz-" + `uname -r`.chomp if !FileTest.exist?(@kernel)
        when "tftpboot" then
          @tftpboot = value.chomp.split[0]
        when "backup" then
          @backup = value.chomp.split[0]
        when "dhcp_cmd" then
          @dhcp_cmd = value.chomp.split[0]
        when "nfs_cmd" then
          @nfs_cmd = value.chomp.split[0]
        when "pxe_cmd" then
          @pxe_cmd = value.chomp.split[0]
        end
      end
    }
  end

  def dhcp
    @dhcp
  end
  def dhcp_i
    @dhcp_i
  end
  def pxe
    @pxe
  end
  def mpich
    @mpich
  end
  def pxe_kernel
    @pxe_kernel
  end
  def kernel
    @kernel
  end
  def tftpboot
    @tftpboot
  end
  def backup
    @backup
  end
  def dhcp_cmd
    @dhcp_cmd
  end
  def nfs_cmd
    @nfs_cmd
  end
  def pxe_cmd
    @pxe_cmd
  end
  def fstab_conf
    "./fstab.conf"
  end
end

if __FILE__ == $0
  a = Path.new
  p a.dhcp
  p a.dhcp_i
  p a.pxe
  p a.mpich
  p a.pxe_kernel
  p a.kernel
  p a.tftpboot
  p a.backup
  p a.dhcp_cmd
  p a.nfs_cmd
  p a.pxe_cmd
  p a.fstab_conf
end
