REM projective transformation of Lissajous curves
REM much time reqired.
DECLARE EXTERNAL PICTURE lissa
OPTION ARITHMETIC NATIVE
DIM T(4,4)
MAT READ T
DATA 1, 0, 0, 0.1
DATA 0, 1, 0,-0.1
DATA 0, 0, 1, 0
DATA 2, 2, 0, 1 
SET WINDOW -80, 80, -80, 80  
FOR a=1 TO 14
   WAIT DELAY 0.01
   SET DRAW mode hidden
   CLEAR
   DRAW axes(10,10)
   SET AREA COLOR a
   DRAW lissa WITH SCALE(a)*T
   SET DRAW mode explicit
NEXT a
END                                                        
EXTERNAL PICTURE lissa
OPTION ARITHMETIC NATIVE
OPTION ANGLE DEGREES
DIM M(0 to 720,2)
FOR t=0 TO 359
   LET M(t,1)=SIN(3*t)
   LET M(t,2)=COS(7*t+15)
NEXT t
MAT PLOT AREA,LIMIT 360:M
END PICTURE
