/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.misc.XtraceStream;

public interface ShTree {

	/**
	 * 
	 * @param env
	 * @param fs
	 * @param cmds
	 * @param run
	 * @param stdin
	 * @param stdout
	 * @param stderr
	 * @param prompt
	 * @return
	 * @throws IOException
	 * @throws ShSyntaxException
	 */
	public int eval(ShEnvironment env,
			ShFileSystem fs,
			ShBuiltInCommands cmds,
			ShRuntime run,
			InputStream stdin,
			PrintStream stdout,
			PrintStream stderr,
			XtraceStream prompt) throws IOException, ShSyntaxException;

	/**
	 * 中間表現を簡易コンパイルします。
	 */
	public void compileInternally(ShTreeExpressionMachine.Builder b,
			Object brk, Object cnt);

}
