/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.conf;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.AbstractShFile;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public abstract class SpecialDir extends AbstractShFile {

	/**
	 * 
	 */
	protected String name;

	/**
	 * 
	 * @param fs
	 * @param virtualpath
	 * @param name
	 */
	public SpecialDir(ShFileSystem fs, String virtualpath,
			String name) {
		super(fs, virtualpath);
		this.name = name;
	}

	abstract ShFile getFile(String name);

	String joinpath(String name) {
		if(name == null) {
			return "#dummy";
		} else if(virtualpath.equals("/")) {
			return "/" + name;
		} else {
			return virtualpath + "/" + name;
		}
	}

	public boolean isDirectory() {
		return true;
	}

	public boolean isExecutable() {
		return true;
	}

	public boolean isExist() {
		return true;
	}

	public boolean isFile() {
		return false;
	}

	public boolean isZeroFile() {
		return false;
	}

	public String getName() {
		return name != null ? name : "/";
	}

	public InputStream getInputStream() throws IOException {
		throw new IOException();
	}

	public PrintStream getPrintStream(
			boolean append) throws IOException {
		throw new IOException();
	}

	public ShProcess getProcess() {
		return null;
	}

	public boolean mkdir() {
		return false;
	}

	public boolean renameTo(ShFile f) {
		return false;
	}

	public boolean rmdir() {
		return false;
	}

	public boolean deleteFile() {
		return false;
	}

}