/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.deculture.cmd;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.morilib.deculture.translate.DecultureSyntaxException;
import net.morilib.deculture.translate.DecultureTranslator;
import net.morilib.deculture.translate.LRObject;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/01/15
 */
public class Deculture {

	/**
	 * 
	 */
	public static final String VERSION = "0.0.0";

	//
	private static final Pattern FP = Pattern.compile(
			"(/?([^/]*/)*)([^/\\.]+)(\\.de?c?u?l?t?u?r?e?)?");

	//
	private static DecultureOptions options;

	//
	private static int parseoption(String[] args) {
		options = new DecultureOptions();
		return 0;
	}

	/**
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		PrintStream ot = null;
		InputStream in = null;
		DecultureTranslator l;
		Matcher m;
		String s;
		char[] b;
		int a, z;

		a = parseoption(args);
		if(args.length <= a || !(m = FP.matcher(args[a])).matches()) {
			options.usage();
			System.exit(1);
		} else {
			options.filename = args[a];
			options.outputFilename = s = m.group(3);
			b = s.toCharArray();
			b[0] = Character.toUpperCase(b[0]);
			try {
				in = new FileInputStream(args[a]);
				l  = LRObject.parse(in);
				if(l == null) {
					options.print("unknownlanguage");
					System.exit(2);
				}

				s  = new String(b) + l.getExtension();
				ot = new PrintStream(new FileOutputStream(s));
				l.translate(ot, options);
				if((z = l.howManyShiftReduceConflicts()) > 0) {
					options.print("shiftreduce",
							z, options.get("conflictplural"));
				}

				if((z = l.howManyReduceReduceConflicts()) > 0) {
					options.print("reducereduce",
							z, options.get("conflictplural"));
				}
				System.exit(0);
			} catch(IOException e) {
				e.printStackTrace();
				System.exit(4);
			} catch(DecultureSyntaxException e) {
				options.perror(e.getMessage(), e.getLineNumber());
				System.exit(2);
			} finally {
				try {
					if(in != null)  in.close();
					if(ot != null)  ot.close();
				} catch(IOException e) {
					e.printStackTrace();
					System.exit(2);
				}
			}
		}
	}

}
