/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jp.sourceforge.deployer.DeployerListener;
import jp.sourceforge.deployer.DirectoryCreateFailException;
import jp.sourceforge.deployer.DirectoryDeleteFailException;
import jp.sourceforge.deployer.FileCreateFailException;
import jp.sourceforge.deployer.FileDeleteFailException;
import jp.sourceforge.deployer.FileMonitor;
import jp.sourceforge.deployer.FileMonitorFailException;
import jp.sourceforge.deployer.FileMonitorListener;
import jp.sourceforge.deployer.Message;

public final class Deployer {
    private List<DeployerListener> _listenerList = new ArrayList<DeployerListener>();
    private File _deployDirectory;
    private Pattern _filePattern;
    private File _workDirectory;
    private FileMonitor _fileMonitor;

    public Deployer(File deployDirectory, Pattern filePattern, File workDirectory) {
        if (deployDirectory == null) {
            throw new IllegalArgumentException(Message.argumentIsNull("deployDirectory"));
        }
        if (!deployDirectory.isDirectory()) {
            throw new IllegalArgumentException(Message.argumentIsNotDirectory("deployDirectory"));
        }
        if (filePattern == null) {
            throw new IllegalArgumentException(Message.argumentIsNull("filePattern"));
        }
        if (workDirectory == null) {
            throw new IllegalArgumentException(Message.argumentIsNull("workDirectory"));
        }
        if (!workDirectory.isDirectory()) {
            throw new IllegalArgumentException(Message.argumentIsNotDirectory("workDirectory"));
        }
        this._deployDirectory = deployDirectory;
        this._filePattern = filePattern;
        this._workDirectory = workDirectory;
        this._fileMonitor = new FileMonitor(this._deployDirectory, this._filePattern);
        this._fileMonitor.addListener(new FileMonitorListenerImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DeployerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Message.argumentIsNull("listener"));
        }
        List<DeployerListener> list = this._listenerList;
        synchronized (list) {
            this._listenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DeployerListener listener) {
        List<DeployerListener> list = this._listenerList;
        synchronized (list) {
            this._listenerList.remove(listener);
        }
    }

    public void monitor() throws FileMonitorFailException {
        this._fileMonitor.monitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy(File file) throws IOException {
        List<DeployerListener> list = this._listenerList;
        synchronized (list) {
            for (DeployerListener l : this._listenerList) {
                l.deployStart(this, file);
            }
        }
        File destDir = this.getDestDirectory(file, this._deployDirectory, this._workDirectory);
        if (destDir.exists()) {
            this.delete(destDir);
            this.deleteWithParent(destDir.getParentFile());
        }
        if (!destDir.mkdirs()) {
            throw new DirectoryCreateFailException(destDir);
        }
        this.decompress(file, destDir);
        List<DeployerListener> list2 = this._listenerList;
        synchronized (list2) {
            for (DeployerListener l : this._listenerList) {
                l.deployEnd(this, file, destDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeploy(File file) throws IOException {
        File destDir = this.getDestDirectory(file, this._deployDirectory, this._workDirectory);
        List<DeployerListener> list = this._listenerList;
        synchronized (list) {
            for (DeployerListener l : this._listenerList) {
                l.undeployStart(this, file, destDir);
            }
        }
        this.delete(destDir);
        this.deleteWithParent(destDir.getParentFile());
        list = this._listenerList;
        synchronized (list) {
            for (DeployerListener l : this._listenerList) {
                l.undeployEnd(this, file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompress(File file, File destDir) throws IOException {
        FileInputStream fileIn = null;
        while (fileIn == null) {
            try {
                fileIn = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                fileIn = null;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        try {
            ZipInputStream zipIn = new ZipInputStream(fileIn);
            try {
                FileLock lock = fileIn.getChannel().lock(0L, Long.MAX_VALUE, true);
                try {
                    ZipEntry zipEntry;
                    while ((zipEntry = zipIn.getNextEntry()) != null) {
                        if (!zipEntry.isDirectory()) {
                            File f = new File(destDir, zipEntry.getName().replace('/', File.separatorChar));
                            List<DeployerListener> list = this._listenerList;
                            synchronized (list) {
                                for (DeployerListener l : this._listenerList) {
                                    l.deployFile(this, file, destDir, f);
                                }
                            }
                            if (!f.createNewFile()) {
                                throw new FileCreateFailException(f);
                            }
                            FileOutputStream fileOut = new FileOutputStream(f);
                            try {
                                int len;
                                byte[] buf = new byte[1024];
                                while ((len = zipIn.read(buf)) != -1) {
                                    fileOut.write(buf, 0, len);
                                }
                                continue;
                            }
                            finally {
                                fileOut.close();
                                continue;
                            }
                        }
                        File dir = new File(destDir, zipEntry.getName().replace('/', File.separatorChar));
                        if (dir.mkdirs()) continue;
                        throw new DirectoryCreateFailException(dir);
                    }
                }
                finally {
                    lock.release();
                }
            }
            finally {
                zipIn.close();
            }
        }
        finally {
            fileIn.close();
        }
    }

    private void delete(File dir) throws IOException {
        for (File f : dir.listFiles()) {
            if (!f.isDirectory()) {
                if (f.delete()) continue;
                throw new FileDeleteFailException(f);
            }
            this.delete(f);
        }
        if (!dir.delete()) {
            throw new DirectoryDeleteFailException(dir);
        }
    }

    private void deleteWithParent(File dir) throws IOException {
        if (this._workDirectory.getAbsolutePath().equals(dir.getAbsolutePath())) {
            return;
        }
        if (dir.listFiles().length > 0) {
            return;
        }
        File parentDir = dir.getParentFile();
        if (!dir.delete()) {
            throw new IOException(Message.directoryDeleteFail(dir.getAbsolutePath()));
        }
        this.deleteWithParent(parentDir);
    }

    private File getDestDirectory(File archiveFile, File deployDirectory, File workDirectory) {
        String name = archiveFile.getAbsolutePath().substring(deployDirectory.getAbsolutePath().length());
        File dir = new File(workDirectory, name);
        return dir;
    }

    private class FileMonitorListenerImpl
    implements FileMonitorListener {
        public void create(FileMonitor monitor, File file) {
            try {
                Deployer.this.deploy(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void delete(FileMonitor monitor, File file) {
            try {
                Deployer.this.undeploy(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void update(FileMonitor monitor, File file) {
            try {
                Deployer.this.undeploy(file);
                Deployer.this.deploy(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

