/*
 * built-in program copyright (C) 2009 H.Niwa
 */


/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <string>

#include "syserr.h"

#include "bin_node.h"
#include "gc.h"
#include "var.h"
#include "pred.h"
#include "context.h"
#include "unify.h"
#include "builtin.h"

int HelpPrint(char* mod, char* name);
int HelpBuiltin(char* name);
int HelpSys(char* name);

int Help(Context* cx, Node* goalscar)
{
	HelpBuiltin("");
	HelpSys("");
	return 1;
}


int HelpPrint(char* mod, char* name)
{
	std::string smodule = (const char*)mod;
	std::string sname = (const char*)name;

	if ((smodule == "") || (smodule == "builtin")) {
		return HelpBuiltin(name);
	} else if (smodule == "sys") {
		return HelpSys(name);
	}
}

int HelpBuiltin(char* name)
{
	std::string sname = (const char*)name;

	printf("<alt PRED...>\n");
	printf("<assert CLAUSE>\n");
	printf("<asserta CLAUSE>\n");
	printf("<assertz CLAUSE>\n");
	printf("<compare EXPRESSION>\n");
	printf("<comparef EXPRESSION>\n");
	printf("<erase CLAUSE>\n");
	printf("<retract CLAUSE>\n");
	printf("<retractpred HEADNAME>\n");
	printf("<f VAR PRED...>\n");
	printf("<func VAR PRED...>\n");
	printf("<findall PRED...>\n");
	printf("<for (VAR lastvalue) PRED...>\n");
	printf("<for (VAR initialvalue lastvalue) PRED...>\n");
	printf("<foreach (VAR LIST) PRED...>\n");
	printf("<map  (VAR LIST) PRED...>\n");
	printf("<include FILENAME>\n");
	printf("<let EXPRESSION>\n");
	printf("<letf EXPRESSION>\n");
	printf("<list>\n");
	printf("<load FILENAME>\n");
	printf("<loop PRED...>\n");
	printf("<module VAR>\n");
	printf("<new>\n");
	printf("<not PRED...>\n");
	printf("<obj OBJECTNAME PRED...>\n");
	printf("<unify MODULENAME PRED...>\n");
	printf("<or PRED PRED PRED ...>\n");
	printf("<quit>\n");
	printf("<quote PRED>\n");
	printf("<rpn VAR RPNEXPRESSION>\n");
	printf("<rpnf VAR RPN-EXPRESSION>\n");
	printf("<timeout limittime PRED>\n");
	printf("<troff>\n");
	printf("<tron>\n");
	printf("<true>\n");
	printf("<false>\n");
	printf("<unknown>\n");
	printf("<!>\n");
	printf("\n");
	
}

int HelpSys(char* name)
{
	std::string sname = (const char*)name;
	printf("::sys <args VAR>\n");
	printf("::sys <DLIBPATH VAR>\n");
//	printf("::sys <cutall>\n");
	printf("::sys <mkpred LIST>\n");
	printf("::sys <writenl LIST>\n");
	printf("::sys <write LIST>\n");
	printf("::sys <w LIST>\n");
	printf("::sys <wnl>\n");
	printf("::sys <wo NUMBER>\n");
	printf("::sys <wx NUMBER>\n");
	printf("::sys <wf NUMBER>\n");
	printf("::sys <wg NUMBER>\n");
	printf("::sys <wtab>\n");
	printf("::sys <fr VAR STRINGS WIDTH>\n");
	printf("::sys <fl VAR STRINGS WIDTH>\n");
	printf("::sys <isNil ARG>\n");
	printf("::sys <isAtom ARG>\n");
	printf("::sys <isList ARG>\n");
	printf("::sys <isPred ARG>\n");
	printf("::sys <isVar ARG>\n");
	printf("::sys <isUndefVar ARG>\n");
	printf("::sys <isFloat ARG>\n");
	printf("::sys <isInteger ARG>\n");
	printf("::sys <isTrue PRED>\n");
	printf("::sys <isFalse PRED>\n");
	printf("::sys <isUnknown PRED>\n");
	printf("::sys <regex PATTERN STRINGS PRE-STRINGS MATCH-STRINGS AFTER-STRINGS>\n");
	printf("::sys <sub PATTERN STRINGS PATTERN OUTPUT-STRINGS>\n");
	printf("::sys <gsub PATTERN STRINGS PATTERN OUTPUT-STRINGS>\n");
	printf("::sys <split VAR STRINGS [TERMINATER]>\n");
	printf("::sys <length VAR LIST>\n");
	printf("::sys <setvar VAR VALUE>\n");
	printf("::sys <setarray VAR VALUE INDEX>\n");
	printf("::sys <random VAR>\n");
	printf("::sys <sin VAR RADIAN>\n");
	printf("::sys <cos VAR RADIAN>\n");
	printf("::sys <tan VAR RADIAN>\n");
	printf("::sys <asin VAR VALUE>\n");
	printf("::sys <acos VAR VALUE>\n");
	printf("::sys <atan VAR VALUE>\n");
	printf("::sys <log VAR VALUE>\n");
	printf("::sys <exp VAR VALUE>\n");
	printf("::sys <sqrt VAR VALUE>\n");
	printf("::sys <abs VAR VALUE>\n");
	printf("::sys <int VAR VALUE>\n");
	printf("::sys <car VAR VALUE>\n");
	printf("::sys <cdr VAR VALUE>\n");
	printf("::sys <cons VAR LIST1 LIST2>\n");
	printf("::sys <code CODE>\n");
	printf("::sys <char VAR STRINGS>\n");
	printf("::sys <byte VAR STRINGS>\n");
	printf("::sys <asciichar VAR STRINGS>\n");
	printf("::sys <utf8char VAR STRINGS>\n");
	printf("::sys <eucchar VAR STRINGS>\n");
	printf("::sys <sjischar VAR STRINGS>\n");
	printf("::sys <concat VAR LIST>\n");
	printf("::sys <bitand VAR NUMBER1 NUMBER2> \n");
	printf("::sys <bitor VAR NUMBER1 NUMBER2>\n");
	printf("::sys <bitxor VAR NUMBER1 NUMBER2>\n");
	printf("::sys <bitnot VAR NUMBER1>\n");
	printf("::sys <shiftl VAR NUMBER SHIFT>\n");
	printf("::sys <shiftr VAR NUMBER SHIFT>\n");
	printf("::sys <eq ARG1 ARG2>\n");
	printf("::sys <noteq ARG1 ARG2>\n");
	printf("::sys <is ARG1 ARG2>\n");
	printf("::sys <getc VAR>\n");
	printf("::sys <putc CHAR>\n");
	printf("::sys <getline VAR [PRED...]>\n");
	printf("::sys <tmpfile VAR>\n");
	printf("::sys <TOKEN VAR PRED...>\n");
	printf("::sys <SKIPSPACE>\n");
	printf("::sys <C [VAR]>\n");
	printf("::sys <N [VAR]>\n");
	printf("::sys <A [VAR]>\n");
	printf("::sys <AN [VAR]>\n");
	printf("::sys <CR [VAR]>\n");
	printf("::sys <CNTL [VAR]>\n");
	printf("::sys <EOF [VAR]>\n");
	printf("::sys <SPACE>\n");
	printf("::sys <PUNCT>\n");
	printf("::sys <STRINGS VAR>\n");
	printf("::sys <WORD VAR>\n");
	printf("::sys <NUM VAR>\n");
	printf("::sys <FNUM VAR>\n");
	printf("::sys <ID VAR>\n");
	printf("::sys <RANGE VAR CHAR1 CHAR2>\n");
	printf("::sys <NONRANGE VAR CHAR1 CHAR2>\n");
	printf("::sys <GETTOKEN VAR>\n");
	printf("::sys <openr FILENAME PRED...>\n");
	printf("::sys <openw FILENAME PRED...>\n");
	printf("::sys <openwp FILENAME PRED...>\n");
	printf("::sys <countnode VAR>\n");
	printf("::sys <gc>\n");

}



