/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver;

import java.io.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;

import com.aibonware.viewnaver.browser.*;
import com.aibonware.viewnaver.browser.basic.*;
import com.aibonware.viewnaver.browser.win32.*;
import com.aibonware.viewnaver.config.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.view.*;
import com.aibonware.viewnaver.window.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.storage.*;
import com.aibonware.viewnaver.task.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.decorator.*;
import com.aibonware.viewnaver.component.*;
import com.aibonware.viewnaver.command.*;
import com.aibonware.viewnaver.server.*;

public class ViewNaver implements Runnable {
	public Config config;
	public MainWindow mainWindow;
	public ThreadWindow threadWindow;
	public static ViewNaver instance;
	public RemoteSite web;
	public ThreadPool threadPool;
	public BrowserFactory browserFactory = null;
	public NaverSession naverSession = null;
	public Cache cache;
	public GoyakuJiten goyakuList = null;
	public IDJitenList idJiten = null;
	public BoardTitles boardTitles = null;
	public ChildWindowActivator childWindowActivator = null;
	public ThreadStorage threadStorage = null;
	public MessageStorage messageStorage = null;
	public DefaultTabContentOrder defaultCategoryComparator = null;
	public FavoriteThreads favoriteThreads = null;
	public DefaultTextOperation deftex = null;
	public MiniServer server = null;

	public DecoratorChain threadDecorator = null;
	public DecoratorChain articleDecorator = null;
	
	public TaskFlowList taskFlowList = null;

	public PosterMenuItemCreator posterMenuItemCreator = null;
	
	public synchronized BrowserFactory getBrowserFactory() {
		return browserFactory;
	}

	public ViewNaver() {
		instance = this;

		config = new Config();

		taskFlowList = new TaskFlowList();
		threadPool = new ThreadPool();
		web = new RemoteSite();
		cache = new Cache();

		boardTitles = createBoardTitles();

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch(Exception e) {
			e.printStackTrace();
		}

//		UIManager.put("swing.boldMetal", Boolean.FALSE);
		JPopupMenu.setDefaultLightWeightPopupEnabled(false);
	}
	
	private BoardTitles createBoardTitles() {
		BoardTitles group = new BoardTitles();
		
/*
		group.addBoardTitle(new BoardTitle("ttalk", "HOT! e[}g[N", BoardType.Text));
		group.addBoardTitle(new BoardTitle("ttravel", "sEόEi", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tmusician", "̎E~[WV", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tkpop", "K-POP", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tjpop", "J-POP", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tactor", "|\E^g", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tmovie", "f", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tkdrama", "؍h}", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tjdrama", "{h}", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tlife", "E", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tcosmetic", "t@bVERX ", BoardType.Text));
		group.addBoardTitle(new BoardTitle("teconomy", "j[XEo", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tsports", "X|[c", BoardType.Text));
		group.addBoardTitle(new BoardTitle("thumor", "[A", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tgame", "Q[", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tanimation", "}KEAj", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tinternet", "PCEC^[lbg", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tcamera", "J ", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tmachine", "P[^CEdi ", BoardType.Text));
		group.addBoardTitle(new BoardTitle("thistory", "`E`|\", BoardType.Text));

		group.addBoardTitle(new BoardTitle("ptravel", "sEόEi", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pplace", "߃X|bg", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pfood", "O", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pstar", "|\E^g", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pfashion", "fEt@bV", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pcostum", "RXv", BoardType.Image));
		group.addBoardTitle(new BoardTitle("psports", "X|[c", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pcar", "N}", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pbike", "oCN", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pmodel", "vfEtBMA", BoardType.Image));
		group.addBoardTitle(new BoardTitle("panimation", "}KEAj", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pgame", "Q[", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pcamera", "vo̎ʐ^", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pfriend", "lEFEƑ", BoardType.Image));
		group.addBoardTitle(new BoardTitle("ppet", "ybgE", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pvillage", "X̕i", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pschool", "wZ̐", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pmything", "̈iE", BoardType.Image));
		group.addBoardTitle(new BoardTitle("phistory", "`EH|", BoardType.Image));
		group.addBoardTitle(new BoardTitle("phumor", "[A", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pmilitary", "~^[", BoardType.Image));
*/

		group.addBoardTitle(new BoardTitle("ttravel", "s", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tlife", "/", BoardType.Text));
		group.addBoardTitle(new BoardTitle("thistory", "`", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tbook", "BOOK", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tselftalk", "ЂƂ茾", BoardType.Text));
		group.addBoardTitle(new BoardTitle("ttrouble", "Y", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tjob", "AE", BoardType.Text));
		group.addBoardTitle(new BoardTitle("thumor", "[A", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tpop", "y", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tdrama", "h}", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tmovie", "f", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tactor", "|\l", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tcosmetic", "t@bV", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tgame", "Q[", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tanimation", "}K/Aj", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tinternet", "IT/fW^", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tdigital", "J/di", BoardType.Text));
		group.addBoardTitle(new BoardTitle("teconomy", "j[X", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tsports", "X|[c", BoardType.Text));
		group.addBoardTitle(new BoardTitle("ttalk", "Hot! _", BoardType.Text));
		group.addBoardTitle(new BoardTitle("tfree", "Rf", BoardType.Text));

		group.addBoardTitle(new BoardTitle("ptravel", "ό/i", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pfood", "O", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pfriend", "l/FB/Ƒ", BoardType.Image));
		group.addBoardTitle(new BoardTitle("ppet", "ybg", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pvillage", "킽̊X", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pmything", "̈i", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pstar", "|\l", BoardType.Image));
		group.addBoardTitle(new BoardTitle("psports", "X|[c", BoardType.Image));
		group.addBoardTitle(new BoardTitle("phumor", "[A", BoardType.Image));
		group.addBoardTitle(new BoardTitle("phistory", "`", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pcar", "N}", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pbike", "oCN", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pmodel", "vf/tBMA", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pgame", "Q[", BoardType.Image));
		group.addBoardTitle(new BoardTitle("panimation", "}K/Aj", BoardType.Image));
		group.addBoardTitle(new BoardTitle("pfree", "RtHgf", BoardType.Image));

		return group;
	}

	public void run() {
		defaultCategoryComparator = new DefaultTabContentOrder();
		mainWindow = new MainWindow();
		childWindowActivator = new ChildWindowActivator(mainWindow);
		threadWindow = new ThreadWindow(mainWindow);
		threadStorage = new ThreadStorage();
		messageStorage = new MessageStorage();
		favoriteThreads = new FavoriteThreads();
		deftex = new DefaultTextOperation();

		threadDecorator  = new DecoratorChain();
		articleDecorator = new DecoratorChain();

		threadDecorator.addDecorator(new EmbeddedMovieDecorator());
		articleDecorator.addDecorator(new LinkGenerator());

		threadDecorator.addDecorator(new GoyakuDecorator());
		articleDecorator.addDecorator(new GoyakuDecorator());

		posterMenuItemCreator = new PosterMenuItemCreator();
				
		config.loadFile("config.xml");
		favoriteThreads.load("favorite.xml");

		makeSureDir("plugins");
		
		String fileNames[] = new File("plugins").list();
		Vector<Plugin> plugins = new Vector<Plugin>();
		
		if(fileNames != null) for(String fileName: fileNames) {
			if(new File(fileName).isFile() && fileName.endsWith(".jar")) {
				try {
					String pluginName = fileName.substring(0, fileName.length()-4);
	
					if(pluginName.contains(".")) pluginName = "com.aibonware.viewnaver.plugins." + pluginName;
					
					Plugin plugin = (Plugin)Class.forName(pluginName).newInstance();
					plugins.addElement(plugin);

				} catch(Exception e) {
					ViewNaver.println("vOC" + fileName + "̃[hɎs܂(" + e.getMessage() + ")B");
				}
			}
		}
		
		Collections.sort(plugins, new Comparator<Plugin>() {
			public int compare(Plugin src, Plugin dest) {
				return src.getPriorityPoint() - dest.getPriorityPoint();
			}
		});
		
		for(Plugin plugin: plugins) {
			try {
				plugin.initialize();
			} catch(Exception e) {
				ViewNaver.println("vOC" + plugin.getName() + "̏Ɏs܂(" + e.getMessage() + ")B");
			}
		}

		try {
			if(browserFactory == null) browserFactory = new Win32BrowserFactory();
				
			browserFactory.initialize();
		} catch(Throwable e) {
			ViewNaver.println("HTML_OGW̏Ɏs܂(" + e.getMessage() + ")B֏s܂B");
			browserFactory = new BasicBrowserFactory();
			browserFactory.initialize();
		}

		ViewNaver.println("viewNVR " + Version.STATUS + " " + Version.MAJOR + "." + Version.MINOR + " rev." + Version.REVISION /*+ " " + Version.DATE*/);
		ViewNaver.println("Rendering Engine: " + browserFactory.getEngineName());
		ViewNaver.println("");

		final LoginDialog loginDialog = new LoginDialog(null, logView, config);

		loginDialog.addWindowListener(new WindowAdapter() {
			public void windowClosed(WindowEvent e) {
				if(!loginDialog.confirmed) {
					browserFactory.terminate();
					System.exit(-1);
					return;
				}

				mainWindow.logView.print(logView.getText());
				logView = mainWindow.logView;
				
				mainWindow.setVisible(true);

//				new ShowWelcomeCommand().run();
			}
		});
		
		loginDialog.setVisible(true);
	}

/*	// Xbhv[workerXbhgprunnable񓯊Ɏs
	public static void runWorker(WorkerTask runnable) {
		instance.threadPool.execute(runnable);
	}
*/

	// workerXbhGUIփANZXKv̂鏈s
	private static boolean runGUI(final Runnable runnable) {
		if(SwingUtilities.isEventDispatchThread()) {
			try {
				runnable.run();
			} catch(RuntimeException e) {
				err(e);
			}
		} else {
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					try {
						runnable.run();
					} catch(RuntimeException e) {
						err(e);
					}
				}
			});
		}
		return true;
	}

	private static LogView logView = new LogView(5, 80);
	
	public static void err(final Exception e) {
		e.printStackTrace();
		
		runGUI(new Runnable() {
			public void run() {
				StringWriter buf = new StringWriter();
				PrintWriter writer = new PrintWriter(buf);

				e.printStackTrace(writer);		
				logView.append(buf.toString());
				writer.close();
			}
		});
	}

	public static void println(final String s) {
		runGUI(new Runnable() {
			public void run() {
				logView.print(s + "\n");
			}
		});
	}

	public void exit() {
		config.saveFile("config.xml");
		
		TaskFlow taskFlow = taskFlowList.createNewFlow();
		
		taskFlow.execute(new WorkerTask() {
			public void exec() {
				try {
					ViewNaver.println("XbhOo͊Jn...");
					int num = ViewNaver.instance.threadStorage.flash();
					ViewNaver.println("XbhOo͏I(" + num + "Xbhۑ)");
				} catch(Exception e) {
					err(e);
				}

				try {
					ViewNaver.println("OAEgJn..");
					if(naverSession != null && naverSession.nowLogin()) naverSession.logout();
					ViewNaver.println("OAEgIB");
				} catch(Exception e) {
					err(e);
				}

				runGUI(new Runnable() {
					public void run() {
						ViewNaver.println("obNOEh^XN̏I...");
						threadPool.shutdownNow();
						mainWindow.dispose();
						if(browserFactory != null) browserFactory.terminate();
						System.exit(0);
					}
				});
			}
		});
	}

	public static String strToHtml(String s) {
		return getArticleHtml(s, false, '\0', '\0');
	}
	
	public static String htmlToStr(String s) {
		s = s.replaceAll("&quot;", "\"");
		s = s.replaceAll("&amp;", "&");
		s = s.replaceAll("&lt;", "<");
		s = s.replaceAll("&gt;", ">");
		s = s.replaceAll("&nbsp;", " ");
		s = s.replaceAll("<br>", "\n");
		
		return s;
	}

	public static String getArticleHtml(String s, boolean unicode, char unicodeStartChar, char unicodeEndChar) {
		if(s == null) return "";

		StringBuffer buf = new StringBuffer();
		int len = s.length();
		
		for(int i=0; i<len; i++) {
			char c = s.charAt(i);

			switch(c) {
				case '"': buf.append("&quot;"); break;
				case '&': buf.append("&amp;"); break;
				case '<': buf.append("&lt;"); break;
				case '>': buf.append("&gt;"); break;
				case ' ': buf.append("&nbsp;"); break;
//				case '\n': buf.append("<br>"); break;
				default: buf.append(c); 
			}
		}

		s = buf.toString();
		
		if(unicode) {
			int start;
			
			while((start = s.indexOf(unicodeStartChar)) != -1) {
				int end = s.indexOf(unicodeEndChar, start);
				
				if(end == -1) break;

				s = s.substring(0, start) 
				    + toUnicode(s.substring(start+1, end))
				    + s.substring(end+1);
			}
		}

		return s;
	}

	private static String toUnicode(String s) {
		StringBuffer buf = new StringBuffer();
		
		for(int i=0; i<s.length(); i++) {
			buf.append("&#" + ((int)s.charAt(i)) + ";");
		}

		return buf.toString();
	}
	
	public static boolean makeSureDir(String dirName) {
		File dir = new File(dirName);
		if(dir.exists()) return true;

		return dir.mkdirs();
	}
	
	private HashMap<Class, Character> allocatedPUAList = new HashMap<Class, Character>();
	
	public char getPUA(Class clazz) {
		synchronized(allocatedPUAList) {
			if(allocatedPUAList.containsKey(clazz)) {
				return allocatedPUAList.get(clazz);
			}

			char c = (char)(0xe000 + allocatedPUAList.size());
			if(c >= 0xe400) throw new IndexOutOfBoundsException("PUA is full");

			allocatedPUAList.put(clazz, c);
			return c;
		}
	}
}
