/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.browser;

import java.awt.*;
import java.util.*;

public abstract class Browser {
	private Vector<BrowserListener> listeners = new Vector<BrowserListener>();

	protected Browser() {}

	public abstract Component getComponent();
	public abstract void setBodyHtml(String html);
	public abstract void insertBodyHtml(String tagid, String html);
	public abstract void replaceBodyHtml(String tagid, String html);
	public abstract String getBodyHtml();

	public void addBrowserListener(BrowserListener listener) {
		listeners.addElement(listener);
	}

	public void removeBrowserListener(BrowserListener listener) {
		listeners.removeElement(listener);
	}

	public boolean notifyBeforeNavigate(String url) {
		boolean mustContinue = true;

		for(int i=0; i<listeners.size(); i++) {
			if(!listeners.elementAt(i).beforeNavigate(url)) mustContinue = false;
		}

		return mustContinue;
	}

	public abstract void scrollTop(String tagid);
	/** @deprecated */
	public abstract void refresh();
	/** @deprecated */
	public abstract void reset();
	
	public void beginDocWriting() {}
	public abstract void writeDocHtml(String html);
	public void endDocWriting() {}
	
	public abstract void clearDocHtml();
	public abstract void closeDocHtml();
}
