/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.browser.win32;

import java.awt.*;
import java.util.*;

import javax.swing.*;

import org.w3c.dom.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.config.*;
import com.aibonware.viewnaver.model.*;

@SuppressWarnings("serial")
public class Win32BrowserConfig  extends ConfigItem {
	public URLActions actions = new URLActions();
	public Set<Poster> persons = new HashSet<Poster>();
	public String startTag = "<font color=\"blue\">";
	public String endTag = "</font>";

	public Win32BrowserConfig() {
		super("BrowserConfig");
		loadConfig(null);
	}

	@Override public void loadConfig(Element elem) {
		actions = new URLActions();
		
		if(elem == null) return;

		NodeList children = elem.getElementsByTagName("URLAction");
		if(children.getLength() == 0) return;

		for(int i=0; i<children.getLength(); i++) {
			Element actionElem = (Element)children.item(i);

			int minAction = Config.getIntConfig(actionElem, "MinAction", -1);
			int maxAction = Config.getIntConfig(actionElem, "MaxAction", -1);
			int policy = Config.getIntConfig(actionElem, "Policy", -1);

			URLAction action = actions.findAction(minAction, maxAction, policy);

			if(action == null) {
				ViewNaver.println("sURLActionw(" + minAction + ", " + maxAction + ", " + policy + ")");
				break;
			}

			action.currentPolicy = policy;
		}
	}

	@Override public void saveConfig(Element elem) {
		NodeList children = elem.getElementsByTagName("URLAction");
		
		for(int i=0; i<children.getLength(); i++) {
			elem.removeChild(children.item(i));
		}

		Document doc = elem.getOwnerDocument();

		for(URLAction a: actions.children) {
			Element actionElem = doc.createElement("URLAction");
			
			Config.setIntConfig(actionElem, "MinAction", a.minAction);
			Config.setIntConfig(actionElem, "MaxAction", a.maxAction);
			Config.setIntConfig(actionElem, "Policy", a.currentPolicy);
			
			elem.appendChild(actionElem);
		}
	}

	@Override public String getDispPath() {
		return "uEU";
	}

	private static class Win32BrowserConfigView extends ConfigItemView {
		JComboBox[] policiesList;
		
		public Win32BrowserConfigView() {
			final URLActions defs = new URLActions();
			
			policiesList = new JComboBox[defs.children.length];

			for(int i=0; i<defs.children.length; i++) {
				final JComboBox plist = new JComboBox(defs.children[i].policies);
//				plist.setMaximumSize(plist.getPreferredSize());
				plist.setPreferredSize(new Dimension(100, 20));
				plist.setMaximumSize(new Dimension(100, 20));
				policiesList[i] = plist;

				final int finalIndex = i;

				addLine(defs.children[finalIndex].name + ": \t", plist);
			}
		}

		Win32BrowserConfig browserConfig;
		
		public void setConfig(ConfigItem config) {
			browserConfig = (Win32BrowserConfig)config;

			for(int i=0; i<browserConfig.actions.children.length; i++) {
				URLAction action = browserConfig.actions.children[i];
					
				policiesList[i].setSelectedIndex(action.getPolicyIndex(action.currentPolicy));
			}
		}

		public void applyConfig() throws ConfigException {
			for(int i=0; i<policiesList.length; i++) {
				URLAction action = browserConfig.actions.children[i];
				action.currentPolicy = action.policies[policiesList[i].getSelectedIndex()].policy;
			}
		}
	}

	@Override public ConfigItemView getView() {
		return new Win32BrowserConfigView();
	}
}
