package com.aibonware.viewnaver.component;

import java.util.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;

@SuppressWarnings("serial")
public class PagePanel extends JPanel {
	private PageLayout pageLayout;
	
	public PagePanel() {
		pageLayout = new PageLayout();
		
		setOpaque(true);
		setBorder(new EmptyBorder(2,2,2,2));
		setLayout(pageLayout);
	}

	public PagePanel(Object... objects) {
		this();
		addLine(objects);
	}
	
	public void insertNewLine() {
		add(pageLayout.createNewLine());
	}
	
	public void insertTab() {
		add(pageLayout.createTab());
	}
	
	public void insertIndent(int indent) {
		add(pageLayout.createHorizonSpace(indent * 10));
	}
	
	@Override public void setBorder(Border newBorder) {
		super.setBorder(new CompoundBorder(newBorder, new EmptyBorder(2,2,2,2)));
	}
	
	public static PageLayout.Glue glue(Component comp) {
		return new PageLayout.Glue(comp);
	}
	
	public static PageLayout.Glue glue() {
		return new PageLayout.Glue(new PageLayout.EmptyGlueComponent());
	}
	
	public Component add(PageLayout.Glue glue) {
		return add(PageLayout.GLUE, glue.comp);
	}

	public Component newline(int distance) {
		return pageLayout.createNewLine(distance);
	}
	
	public final void addLine(Object... objects) {
		for(Object obj: objects) {
			if(obj instanceof PageLayout.Glue) {
				add(PageLayout.GLUE, ((PageLayout.Glue)obj).comp);
			} else if(obj instanceof String) {
				String s = (String)obj;
				
				int indent = 0;
				
				while(s.length() > 0 && s.charAt(0) == ' ') {
					indent++;
					s = s.substring(1);
				}

				if(indent > 0) insertIndent(indent);
				
				StringTokenizer tokens = new StringTokenizer(s, "\n\t", true);
				
				while(tokens.hasMoreTokens()) {
					String token = tokens.nextToken();
					
					if(token.equals("\n")) {
						add(pageLayout.createNewLine());
					} else if(token.equals("\t")) {
						add(pageLayout.createTab());
					} else {
						add(new JLabel(token));
					}
				}
				
			} else {
				add((Component)obj);
			}
		}
		
		add(pageLayout.createNewLine());
	}


	private int indexOf(Component comp) {
		Component[] comps = this.getComponents();
		
		for(int i=0; i<comps.length; i++) {
			if(comps[i] == comp) return i;
		}

		return -1;
	}
	
	public void setLineEnabled(boolean b, Component main) {
		Component[] comps = this.getComponents();

		int pos = indexOf(main);

		if(pos == -1) return;
		

		int i = pos;
		
		for(;;) {
			i--;
			
			if(i < 0 || comps[i] instanceof PageLayout.NewLine) {
				break;
			}
			
			comps[i].setEnabled(b);
		}

		i = pos;
	
		for(;;) {
			comps[i].setEnabled(b);

			i++;
			
			if(i >= comps.length || comps[i] instanceof PageLayout.NewLine) {
				break;
			}
		}
	}
}
