/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.board;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.task.*;

public class BoardContent extends BaseBoardContent<Board> {
	public BoardContent(Board board) {
		super(board);
	}

	static class BoardClientContentCategory implements TabContentCategory {
		public final String boardName;
		public final String dispName;
		
		public BoardClientContentCategory(String boardName, String dispName) {
			this.boardName = boardName;
			this.dispName = dispName;
		}

		@Override public boolean equals(Object o) {
			if(!(o instanceof BoardClientContentCategory)) return false;
			BoardClientContentCategory dest = (BoardClientContentCategory)o;

			if(!boardName.equals(dest.boardName)) return false;
	
			return true;
		}

		public void createInitialContent(final TabContainer container, final TabContainerView containerView, TabContentView initialView) {
			TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getBoardFlow(boardName, 1);

			taskFlow.addStatusReceiver(((BoardView)initialView).createTaskStatusReceiver(taskFlow));
			
			taskFlow.execute(new WorkerTask() {
				public void exec() {
					final Board board = ViewNaver.instance.cache.getBoard(boardName, 1, true);

					taskFlow.execute(new GUITask() {
						public void exec() {
							if(board == null) {
								containerView.revertEmptyView(BoardClientContentCategory.this);
								return;
							}

							final BoardContent content = new BoardContent(board);

							container.addContent(content);
							containerView.activate(content.getCategory());
						}
					});
				}
			});
		}

		public String getCategoryName() {
			return dispName;
		}

		@Override public int hashCode() {
			return boardName.hashCode();
		}
		

		public Class getContentClass() {
			return BoardContent.class;
		}
	};

	public String getContentTitle() {
		return target.dispName;
	}
	
	public TabContentCategory getCategory() {
		return getCategory(target.boardName);
	}

	public static TabContentCategory getCategory(String boardName) {
		BoardTitle board =ViewNaver.instance.boardTitles.getBoardTitle(boardName);
		if(board == null) {
			return new BoardClientContentCategory(boardName, boardName);
		} else {
			return new BoardClientContentCategory(boardName, board.dispName);
		}
	}

	public void replaceUpdatedContent(final TabContainer container, final TabContainerView containerView, TabContentView contentView) {
		TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getBoardFlow(target.boardName, target.pageNo);

		taskFlow.addStatusReceiver(((BoardView)contentView).createTaskStatusReceiver(taskFlow));
		
		taskFlow.execute(new WorkerTask() {
			public void exec() {
				final Board newBoard = ViewNaver.instance.cache.getBoard(target.boardName, target.pageNo, true);

				taskFlow.execute(new GUITask() {
					public void exec() {
						if(newBoard != null) {
							TabContent newContent = new BoardContent(newBoard);
	
							container.replace(BoardContent.this, newContent);
							containerView.activate(newContent.getCategory());
						} else {
							
						}
					}
				});
			}
		});
	}
}
