/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.board;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.task.*;

public class FoundThreadsContent extends BaseBoardContent<FoundThreads> {
	public FoundThreadsContent(FoundThreads threads) {
		super(threads);
	}

	public static class FoundThreadsCategory implements TabContentCategory {
		public final String boardName;
		public final String dispName;
		public final BoardType boardType;
		public final String keyword;
		public final SearchType searchType;
		public final int pageNo;

		public FoundThreadsCategory(String boardName, String dispName, BoardType boardType, SearchType searchType, String keyword) {
			this(boardName, dispName, boardType, searchType, keyword, 1);
		}
		
		public FoundThreadsCategory(String boardName, String dispName, BoardType boardType, SearchType searchType, String keyword, int pageNo) {
			this.boardName = boardName;
			this.dispName = dispName;
			this.boardType = boardType;
			this.searchType = searchType;
			this.keyword = keyword;
			this.pageNo = pageNo;
		}

		public void createInitialContent(final TabContainer container, final TabContainerView containerView, TabContentView initialView) {
			TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getSearchRemoteThreadFlow(boardName, searchType, keyword);

			taskFlow.addStatusReceiver(((FoundThreadsView)initialView).createTaskStatusReceiver(taskFlow));
		
			taskFlow.execute(new WorkerTask() {
				public void exec() {
					final FoundThreads threads = searchType.execSearch(
							boardName, 
							dispName, 
							boardType, 
							keyword, 
							1);

					taskFlow.execute(new GUITask() {
						public void exec() {
							
							if(threads == null) {
								containerView.revertEmptyView(FoundThreadsCategory.this);
								return;
							}

							final FoundThreadsContent content = new FoundThreadsContent(threads);

							container.addContent(content);
							containerView.activate(content.getCategory());
						}
					});
				}
			});
		}
		
		public String getCategoryName() {
			return "";
		}

		@Override public boolean equals(Object o) {
			if(o == null) return false;
			if(!(o instanceof FoundThreadsCategory)) return false;

			FoundThreadsCategory dest = (FoundThreadsCategory)o;

//			if(pageNo != dest.pageNo) return false;
			if(!boardName.equals(dest.boardName)) return false;
			if(!searchType.equals(dest.searchType)) return false;
			return keyword.equals(dest.keyword);
		}

		@Override public int hashCode() {
			return boardName.hashCode() + searchType.hashCode() + keyword.hashCode();
		}

		public Class getContentClass() {
			return FoundThreadsContent.class;
		}
	};

	public String getContentTitle() {
		return "";
	}
	public TabContentCategory getCategory() {
		FoundThreads threads = (FoundThreads)target;

		return new FoundThreadsCategory(threads.boardName, threads.dispName, threads.boardType, threads.searchType, threads.keyword, threads.pageNo);
	}

	public static TabContentCategory getConstantCategory(BoardTitle title, SearchType searchType, String keyword) {
		return new FoundThreadsCategory(
				title.boardName, 
				title.dispName, 
				title.boardType, 
				searchType, 
				keyword);
	}

	public void replaceUpdatedContent(final TabContainer container, final TabContainerView containerView, TabContentView contentView) {
		TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getSearchRemoteThreadFlow(target.boardName, target.searchType, target.keyword);

		taskFlow.addStatusReceiver(((FoundThreadsView)contentView).createTaskStatusReceiver(taskFlow));
		
		taskFlow.execute(new WorkerTask() {
			public void exec() {
				final FoundThreads threads = target.searchType.execSearch(
						target.boardName, 
						target.dispName, 
						target.boardType, 
						target.keyword, 
						target.pageNo);

				taskFlow.execute(new GUITask() {
					public void exec() {
						if(threads == null) return;

						final FoundThreadsContent content = new FoundThreadsContent(threads);

						container.replace(FoundThreadsContent.this, content);
						containerView.activate(content.getCategory());
					}
				});
			}
		});
	}
}
