/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.board;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractAction;
import javax.swing.JButton;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.config.ThreadListConfig;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.task.*;
import com.aibonware.viewnaver.window.SearchRemoteThreadDialog;

@SuppressWarnings("serial")
public class FoundThreadsView extends BaseBoardView<FoundThreads> {
	JButton searchThreadButton = new JButton();
	
	AbstractAction searchThreadAction = new AbstractAction("") {
		public void actionPerformed(ActionEvent e) {
			if(!ViewNaver.instance.naverSession.nowLogin()) {
				ViewNaver.println("OCĂ܂B");
				return;
			}

			FoundThreadsContent.FoundThreadsCategory category = 
				(FoundThreadsContent.FoundThreadsCategory)FoundThreadsView.this.category;
			
			SearchRemoteThreadDialog dialog = new SearchRemoteThreadDialog(
					ViewNaver.instance.mainWindow, 
					new BoardTitle(category.boardName, category.dispName),
					category.keyword,
					category.searchType);

			dialog.setVisible(true);
		}
	};

	public FoundThreadsView(TabContentCategory category) {
		super(category);

		searchThreadButton.setAction(searchThreadAction);
		toolbar.add(searchThreadButton);
	}

	public TaskStatusReceiver createTaskStatusReceiver(final TaskFlow taskFlow) {
		return new TaskStatusReceiver() {
			public void statusChanged(int status) {
				if(status == RUNNING) {
					searchThreadButton.setAction(new AbstractAction("~") {
						public void actionPerformed(ActionEvent e) {
							taskFlow.cancel();
						}
					});

					prevButton.setEnabled(false);
					nextButton.setEnabled(false);
					closeButton.setEnabled(false);
					
				}  else if(status == FINISHED) {
					searchThreadButton.setAction(searchThreadAction);
	
					prevButton.setEnabled(true);
					nextButton.setEnabled(true);
					closeButton.setEnabled(true);
				}
			}
		};
	}

	@Override protected void loadNewPage(final FoundThreads oldboard, final int pageNo, boolean forceUpdate) {
		TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getSearchRemoteThreadFlow(oldboard.boardName, oldboard.searchType, oldboard.keyword);

		taskFlow.addStatusReceiver(createTaskStatusReceiver(taskFlow));
		
		taskFlow.execute(new WorkerTask() {
			public void exec() {
				int newPageNo = getSpecifiedPageNo();

				if(newPageNo < 1) {
					ViewNaver.println("sȃy[WԍłB");
					return;
				}

				final FoundThreads newThreads = oldboard.searchType.execSearch(
						oldboard.boardName, 
						oldboard.dispName, 
						oldboard.boardType, 
						oldboard.keyword, 
						newPageNo);

				if(newThreads == null) return;

				taskFlow.execute(new GUITask() {
					public void exec() {
						ViewNaver.instance.mainWindow.containerView.update(new FoundThreadsContent(newThreads));
					}
				});
				
			}
		});
	}

	@Override protected ThreadListConfig getConfig() {
		return ViewNaver.instance.config.searchConfig;
	}
}
