/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.favorite;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.model.*;

public class FavoriteContent implements TabContent {
	FavoriteThreads threads;

	public FavoriteContent(FavoriteThreads threads) {
		this.threads = threads;
	}

	private static class FavoriteContentCategory implements TabContentCategory {
		public FavoriteContentCategory() {}

		@Override public boolean equals(Object o) {
			if(o == null) return false;
			return (o instanceof FavoriteContentCategory);
		}

		public void createInitialContent(final TabContainer container, final TabContainerView containerView, TabContentView initialView) {
			final FavoriteContent content = new FavoriteContent(ViewNaver.instance.favoriteThreads);

			container.addContent(content);
			containerView.activate(content.getCategory());
		}
		
		public String getCategoryName() {
			return "Cɓ";
		}

		@Override public int hashCode() {
			return FavoriteContentCategory.class.hashCode();
		}

		public Class getContentClass() {
			return FavoriteContent.class;
		}
	};

	public String getContentTitle() {
		return "Cɓ";
	}

	public TabContentCategory getCategory() {
		return new FavoriteContentCategory();
	}

	public static TabContentCategory getConstantCategory() {
		return new FavoriteContentCategory();
	}
	
	public void replaceUpdatedContent(final TabContainer container, final TabContainerView containerView, TabContentView contentView) {
		container.replace(FavoriteContent.this, new FavoriteContent(ViewNaver.instance.favoriteThreads));
	}
}
