/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.favorite;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.table.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.command.*;
import com.aibonware.viewnaver.content.*;

@SuppressWarnings("serial")
public class FavoriteContentView extends TabContentView {
	private FavoriteThreads threads;
	protected JTable table;
	private static TableColumnModel tableColumnModel = null;
	protected JTextField pageText;
	protected JButton closeButton;
	protected JButton deleteButton;
	protected JToolBar toolbar;
	private FavoriteContent content;

	private Object[] headerNames = new Object[] {"board", "country",  "poster", "title"};
	private int[] headerWidthList = new int[] {60, 30, 80, 250};

	private DefaultTableModel tableModel = new DefaultTableModel(headerNames, 0) {
		@Override public boolean isCellEditable(int row, int column) {
			return false;
		}
	};

	private class RowToolTipTable extends JTable {
		public RowToolTipTable(TableModel tableModel) {
			super(tableModel);
			setToolTipText("");
		}
		
		public RowToolTipTable(TableModel tableModel, TableColumnModel tableColumnModel) {
			super(tableModel, tableColumnModel);
			setToolTipText("");
		}

		public String getToolTipText(MouseEvent event) {
			int row = this.rowAtPoint(event.getPoint());
			
			if(row == -1) return null;
			
			FavoriteThread thread = threads.getThread(row);

			return thread.title;
		}
	}

	public FavoriteContentView(TabContentCategory category) {
		super(category);
	
		if(tableColumnModel == null) {
			table = new RowToolTipTable(tableModel);
			tableColumnModel = table.getColumnModel();
			
			for(int i=0; i<headerWidthList.length; i++) {
				tableColumnModel.getColumn(i).setPreferredWidth(headerWidthList[i]);
			}

		} else {
			table = new RowToolTipTable(tableModel, tableColumnModel);
		}

		table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

		table.addMouseListener(new MouseAdapter() {
			@Override public void mouseClicked(MouseEvent event) {
				if(event.getClickCount() < 2) return;
	
				int row = table.rowAtPoint(event.getPoint());
				if(row == -1) return;

				final FavoriteThread thread = FavoriteContentView.this.threads.getThread(row);

				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(thread.boardName, thread.nid);

				//String boardName, int nid, String poster, String threadTitle
				taskFlow.execute(new ShowThreadCommand(
						thread.boardName,
						thread.nid,
						thread.poster,
						thread.title));
			}
		});

		closeButton = new JButton("");
		deleteButton = new JButton("폜");
		
		closeButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ViewNaver.instance.mainWindow.container.removeContent(content);
			}
		});

		deleteButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int row = table.getSelectedRow();
				if(row < 0) return;
				
				tableModel.removeRow(row);
				ViewNaver.instance.favoriteThreads.removeThread(row);
				ViewNaver.instance.favoriteThreads.save("favorite.xml");
			}
		});
		
		toolbar = new JToolBar();

		toolbar.add(closeButton);
		toolbar.addSeparator();
		toolbar.add(deleteButton);

		toolbar.setFloatable(false);

		add(toolbar, BorderLayout.NORTH);
		add(new JScrollPane(table), BorderLayout.CENTER);
	}

	public void setClientContent(TabContent c) {
		content = (FavoriteContent)c;

		threads = content.threads;

		tableModel.setRowCount(0);

		for(int i=0; i<threads.getThreadCount(); i++) {
			FavoriteThread thread = threads.getThread(i);

			tableModel.addRow(new Object[] {
					thread.boardName, thread.country, thread.poster, ViewNaver.htmlToStr(thread.title)});
		}
	}
}
