/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.message;

import java.awt.*;
import javax.swing.border.*;
import java.awt.event.*;

import javax.swing.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.parser.*;
import com.aibonware.viewnaver.task.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.browser.*;
import com.aibonware.viewnaver.command.*;

@SuppressWarnings("serial")
public abstract class MessageContentView extends TabContentView {
	private JLabel infoLabel = new JLabel(" ");
	protected final MessageListView messageListView;
	private Browser messageArea;
	
	private JLabel messageHeader;
	protected MessageContent messageContent;

	protected JToolBar toolbar;
	private JButton closeButton;
	private JButton updateButton;
	private JButton serverButton;

	JPopupMenu serverPopup = new JPopupMenu();
	
	AbstractAction serverAction = new AbstractAction("T[o...") {
		public void actionPerformed(ActionEvent e) {
			serverPopup.show(serverButton,0, serverButton.getHeight());
		}
	};

	
	AbstractAction updateAction = new AbstractAction("XV") {
		public void actionPerformed(ActionEvent e) {
			ViewNaver.instance.mainWindow.containerView.update(messageContent.getCategory());
		}
	};
	
	public TaskStatusReceiver createUpdateTaskStatusReceiver(TaskFlow taskFlow) {
		return new DefaultTaskStatusReceiver(taskFlow, updateButton, updateAction, serverButton, closeButton);
		
	}
	
	public MessageContentView(final TabContentCategory category, String messageUrlBase, MessageListView.MessageAdapter messageSaver) {
		super(category);

		messageArea = ViewNaver.instance.getBrowserFactory().createBrowser();
		
		messageArea.beginDocWriting();
		messageArea.writeDocHtml(
				"<html><head>"
				+ "<meta http-equiv=\"Content-Type\" content=\"text/html\">"
				+ "</head><body></body></html>");
		messageArea.endDocWriting();

//		messageArea = new SwingBrowserFactory().createBrowser("");

		messageHeader = new JLabel(" ");
		messageHeader.setOpaque(true);

		messageListView = new MessageListView(messageArea, messageUrlBase, messageHeader, messageSaver);

		JSplitPane split = new JSplitPane(JSplitPane.VERTICAL_SPLIT);

		split.setTopComponent(new JScrollPane(
				messageListView, 
				ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED, 
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER) {{
					getViewport().setBackground(Color.WHITE);
		}});
		
		split.setBottomComponent(new JPanel(new BorderLayout()) {{
			add(messageHeader, BorderLayout.NORTH);
//			add(new JScrollPane(messageArea.getComponent()), BorderLayout.CENTER);
			add(new JPanel(new BorderLayout()) {{ 
				setBorder(new BevelBorder(1));
				add(messageArea.getComponent()); 
			}}, BorderLayout.CENTER);
		}});

		messageArea.addBrowserListener(new BrowserListener() {
			public boolean beforeNavigate(final String url) {
				SwingUtilities.invokeLater(new Runnable() {	
					public void run() {
						new OpenURLCommand(MessageContentView.this, url, false).run();
					}
				});

				return false;
			}			
		});
		
//		split.setBottomComponent(messageArea);

		split.setDividerSize(5);
		split.setResizeWeight(0);

		add(split, BorderLayout.CENTER);
		add(infoLabel, BorderLayout.SOUTH);

		split.setDividerLocation(100);
		
		toolbar = new JToolBar();
		toolbar.setFloatable(false);
		
		updateButton = new JButton();
		closeButton = new JButton("");
		serverButton = new JButton();

		JMenuItem saveServerMenu = new JMenuItem("T[oɒۊ");
		JMenuItem deleteServerMenu = new JMenuItem("T[o폜");

		serverButton.setAction(serverAction);

		saveServerMenu.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				final int[] messageIdList = messageListView.getSelectedMessageIdList();
				
				if(messageIdList.length == 0) {
					ViewNaver.println("bZ[WIĂ܂B");
					return;
				}
				
				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getMessageListFlow();

				taskFlow.addStatusReceiver(new DefaultTaskStatusReceiver(
						taskFlow, serverButton, serverAction, updateButton, closeButton));
				
				taskFlow.execute(new WorkerTask() { 
					 public void exec() {
						try {
							ViewNaver.println("bZ[W̃T[oۑJn..");
							saveServerMessage(messageIdList);
							ViewNaver.println("bZ[W̃T[oۑIB");
							
							taskFlow.execute(new GUITask() {
								public void exec() {
									ViewNaver.instance.mainWindow.containerView.update(messageContent.getCategory());
								}
							});

						} catch(NetException e) {
							ViewNaver.err(e);
						}
					}
				});
			}
		});

		deleteServerMenu.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				final int[] messageIdList = messageListView.getSelectedMessageIdList();
				
				if(messageIdList.length == 0) {
					ViewNaver.println("bZ[WIĂ܂B");
					return;
				}
				
				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getMessageListFlow();

				taskFlow.addStatusReceiver(new DefaultTaskStatusReceiver(
						taskFlow, serverButton, serverAction, updateButton, closeButton));
				
				taskFlow.execute(new WorkerTask() { 
					 public void exec() {
						try {
							ViewNaver.println("bZ[W̃T[o폜Jn..");
							deleteServerMessage(messageIdList);
							ViewNaver.println("bZ[W̃T[o폜IB");

							taskFlow.execute(new GUITask() {
								public void exec() {
									ViewNaver.instance.mainWindow.containerView.update(messageContent.getCategory());
								}
							});
						} catch(NetException e) {
							ViewNaver.err(e);
						}
					}
				});
			}
		});


		closeButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ViewNaver.instance.mainWindow.container.removeContent(messageContent);
			}
		});

		updateButton.setAction(updateAction);

		serverPopup.add(saveServerMenu);
		serverPopup.add(deleteServerMenu);

		toolbar.add(updateButton);
		toolbar.add(closeButton);
		toolbar.addSeparator();
		toolbar.add(serverButton);

		add(toolbar, BorderLayout.NORTH);
	}

	protected abstract void saveServerMessage(int[] messageIdList) throws NetException;
	protected abstract void deleteServerMessage(int[] messageIdList) throws NetException;

	public void setClientContent(TabContent content) {
		messageContent = (MessageContent)content;
		
		MessageTitleList summaryTarget = messageContent.messageTitles;

		if(summaryTarget != null) {
			infoLabel.setText("M: " + summaryTarget.sendNum + " M: " + summaryTarget.receivedNum + " (: " + summaryTarget.preReceivedNum + ")");

		} else {
			infoLabel.setText("---");
		}
	
		messageListView.setMessageList(messageContent.messageTitles);
	}
	
	public String getReplyMessageText(MessageTitle src) throws ParsingException, NetException {
		ReplyMessageParser parser = new ReplyMessageParser(
				"http://bbs.enjoykorea.jp/memo/memo_write.php?receive_id=" 
				+ src.person + "&id_national=" 
				+ src.country.toChar() 
				+ "&st=" + src.messageId);

		return parser.parse();
	}
}
