/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.message;

import java.util.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.storage.*;

public class SentMessageContent extends MessageContent {
	private static final String listUrl = "http://bbs.enjoykorea.jp/memo/save_list.php";
	private static final String title = "M";
	private static final MessageLogReader messageLogReader = new MessageLogReader() {
		public TreeMap<Integer, Message> getMessageLog() {
			try {
				return ViewNaver.instance.messageStorage.getSentMessages(ViewNaver.instance.naverSession.getUserName());
			} catch(StorageException e) {
				ViewNaver.err(e);
				return null;
			}
		}
	};
	
	public SentMessageContent(MessageTitleList messages) {
		super(messages, listUrl, title, messageLogReader);
	}

	protected static class SentMessageContentCategory extends MessageContentCategory {
		public SentMessageContentCategory(String listUrl, String title) {
			super(listUrl, title, messageLogReader);
		}
		
		public MessageContent createMessageContent(MessageTitleList messages) {
			return new SentMessageContent(messages);
		}
		public Class getContentClass() {
			return SentMessageContent.class;
		}
	}
	
	public static TabContentCategory getConstantCategory() {
		return new SentMessageContentCategory(listUrl, title);
	}

	public TabContentCategory getCategory() {
		return new SentMessageContentCategory(listUrl, title);
	}
}
