/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.thread;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.window.*;
import com.aibonware.viewnaver.browser.*;
import com.aibonware.viewnaver.command.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.format.*;
import com.aibonware.viewnaver.content.favorite.*;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskStatusReceiver;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.*;

@SuppressWarnings("serial")
public class ThreadView extends TabContentView {
	public PostArticleView postArticleView;
	ReplyArticleWindow replyArticleWindow;
	public Browser browser;

	private ThreadContent clientContent = null;
	public CompositeThread compositeThread = null;
	private Article selectedArticle = null;
	private DefaultPosterSelection posterSelection = new DefaultPosterSelection();

	public JButton replyThreadButton = new JButton("ԐMX");
	public JButton modifyThreadButton = new JButton("XC");
	public JButton deleteThreadButton = new JButton("X폜");
	public JButton favoriteButton = new JButton("Cɓɒǉ");
	public JButton moveNewButton = new JButton("VɈړ");
	public JButton publishButton = new JButton("Jp\");

	JButton updateButton = new JButton("XV");
	JButton closeButton = new JButton("");

	JMenuItem deleteArticleMenu;

	private DefaultFormatter threadFormatter = new DefaultFormatter();

	public TaskStatusReceiver createTaskStatusReceiver(final TaskFlow taskFlow) {
		return new TaskStatusReceiver() {
			public void statusChanged(int status) {
				if(status == RUNNING) {
					updateButton.setAction(new AbstractAction("~") {
						public void actionPerformed(ActionEvent e) {
							taskFlow.cancel();
						}
					});

					replyThreadButton.setEnabled(false);
					modifyThreadButton.setEnabled(false);
					deleteThreadButton.setEnabled(false);
					favoriteButton.setEnabled(false);
					moveNewButton.setEnabled(false);
					closeButton.setEnabled(false);
					publishButton.setEnabled(false);
					
				}  else if(status == FINISHED) {
					updateButton.setAction(updateAction);
	
					replyThreadButton.setEnabled(true);
					modifyThreadButton.setEnabled(true);
					deleteThreadButton.setEnabled(true);
					favoriteButton.setEnabled(true);
					moveNewButton.setEnabled(true);
					closeButton.setEnabled(true);
					publishButton.setEnabled(true);
				}
			}
		};
	}

	AbstractAction updateAction = new AbstractAction("XV") {
		public void actionPerformed(ActionEvent e) {
			TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(compositeThread.boardName, compositeThread.thread.nid);

			taskFlow.addStatusReceiver(createTaskStatusReceiver(taskFlow));

			taskFlow.execute(new WorkerTask() {
				public void exec() {
					updateThread();
				}
			});
		}
	};

	public ThreadView(TabContentCategory category) {
		super(category);

		setLayout(new BorderLayout());

		postArticleView = new PostArticleView(new Runnable() {
			public void run() {
				updateThread();
			}
		}, false);
		
		replyArticleWindow = new ReplyArticleWindow(ViewNaver.instance.threadWindow, new Runnable() {
			public void run() {
				updateThread();
			}
		});

		replyArticleWindow.setSize(600, 120);

		browser =ViewNaver.instance.getBrowserFactory().createBrowser();

		JPanel panel = new JPanel(new BorderLayout());
		panel.setBorder(new BevelBorder(BevelBorder.LOWERED));
		panel.add(browser.getComponent());

		updateButton.addActionListener(updateAction);

		closeButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ViewNaver.instance.threadWindow.container.removeContent(clientContent);
			}
		});

		replyThreadButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ReplyThreadWindow replyThreadWindow = new ReplyThreadWindow(
					ViewNaver.instance.mainWindow, compositeThread.boardName, compositeThread.thread, compositeThread.contents);

				replyThreadWindow.setVisible(true);
			}
		});

		modifyThreadButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ModifyThreadWindow modifyThreadWindow = new ModifyThreadWindow(
					ViewNaver.instance.mainWindow, compositeThread.boardName, compositeThread.thread, compositeThread.contents);

				modifyThreadWindow.setVisible(true);
			}
		});

		deleteThreadButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int confirm = JOptionPane.showConfirmDialog(ThreadView.this, "Xbh폜܂B낵ł?", "mF", JOptionPane.YES_NO_OPTION);
				
				if(confirm != JOptionPane.YES_OPTION) return;
				
				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(compositeThread.boardName, compositeThread.thread.nid);

				taskFlow.addStatusReceiver(createTaskStatusReceiver(taskFlow));
	
				taskFlow.execute(new WorkerTask() {
					public void exec() {
						try {
							ViewNaver.println("Xbh폜Jn..");

							ViewNaver.instance.naverSession.deleteThread(compositeThread.boardName, compositeThread.thread.nid);
						} catch(NetException e) {
							ViewNaver.err(e);
						}
					}
				});
			}
		});
		
		favoriteButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(ViewNaver.instance.favoriteThreads.exists(compositeThread.boardName, compositeThread.thread.nid)) return;
				
				ViewNaver.instance.favoriteThreads.addThread(new FavoriteThread(
						compositeThread.boardName, 
						compositeThread.thread.nid,
						compositeThread.thread.poster,
						compositeThread.thread.country,
						compositeThread.thread.createDate,
						compositeThread.thread.title
				));
				
				ViewNaver.instance.favoriteThreads.save("favorite.xml");
				
				ViewNaver.println("'" + compositeThread.thread.poster + ": " + compositeThread.thread.title + "'Cɓɒǉ܂B");
				
				TabContainerView containerView = ViewNaver.instance.mainWindow.containerView;
				TabContentCategory category = FavoriteContent.getConstantCategory();

				containerView.update(category);
			}
		});
		
		moveNewButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Article art = null;
				
				for(int i=0; i<compositeThread.articleList.getArticleCount(); i++) {
					Article a = compositeThread.articleList.getArticle(i);
					if(a.isNew) {
						FilterType filter = ViewNaver.instance.config.filterConfig.filters.get(
							new Poster(a.author, a.country));
						
						if(filter == null || !filter.equals(FilterType.Hidden)) {
							art = a;
							break;
						}
					}
				}

				if(art != null) {
					browser.scrollTop("comment:" + art.articleId);
				} else {
					int lastIndex = compositeThread.articleList.getArticleCount()-1;
					if(lastIndex >= 0) {
						browser.scrollTop("comment:" + compositeThread.articleList.getArticle(lastIndex).articleId);
					}
				}
			}
		});
		
		publishButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				PublishableThreadWindow publishWindow = new PublishableThreadWindow(
						ViewNaver.instance.mainWindow, compositeThread);

				publishWindow.setVisible(true);
			}
		});

		JToolBar toolbar = new JToolBar();
		toolbar.add(updateButton);
		toolbar.add(moveNewButton);
		toolbar.addSeparator();
		toolbar.add(closeButton);
		toolbar.addSeparator();
		toolbar.add(replyThreadButton);
		toolbar.add(modifyThreadButton);
		toolbar.add(deleteThreadButton);
		toolbar.addSeparator();
		toolbar.add(favoriteButton);
		toolbar.add(publishButton);
		
		toolbar.setFloatable(false);

		add(toolbar, BorderLayout.NORTH);
		add(panel, BorderLayout.CENTER);
		add(postArticleView, BorderLayout.SOUTH);

		final JPopupMenu popup = new JPopupMenu();

		popup.add(new JMenuItem(new AbstractAction("ڽۯɕԐM") {
			public void actionPerformed(ActionEvent e) {
/*				postReplyRadio.setEnabled(true);
				postReplyRadio.setText("ԐM(eڽ:" + selectedArticle.author + " "  + df.format(selectedArticle.postDate) + ")");
				postReplyRadio.setSelected(true);
				articleText.requestFocusInWindow();
*/
				Point mousePoint = MouseInfo.getPointerInfo().getLocation();

				replyArticleWindow.setLocation(mousePoint.x - 100, mousePoint.y);

				replyArticleWindow.setVisible(true);
				replyArticleWindow.replyArticleView.articleText.requestFocusInWindow();
			}
		}));

		popup.add(deleteArticleMenu = new JMenuItem(new AbstractAction("ڽ폜") {
			public void actionPerformed(ActionEvent e) {
				if(ViewNaver.instance.naverSession == null) {
					ViewNaver.println("OCĂ܂B");
					return;
				}

				int confirm = JOptionPane.showConfirmDialog(ThreadView.this, "ڽ폜܂B낵ł?", "mF", JOptionPane.YES_NO_OPTION);
				if(confirm != JOptionPane.YES_OPTION) return;

				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getArticleFlow(compositeThread.boardName, compositeThread.thread.nid, selectedArticle.articleId);

				taskFlow.addStatusReceiver(createTaskStatusReceiver(taskFlow));
				
				taskFlow.execute(new WorkerTask() {
					public void exec() {
						try {
							ViewNaver.println("ڽ폜...");
							ViewNaver.instance.naverSession.deleteArticle(compositeThread.boardName, compositeThread.thread.nid, selectedArticle.articleId);
							updateThread();
						} catch(NetException e) {
							ViewNaver.println(e.getMessage());
						}
					}
				});
			}
		}));
	
		popup.addSeparator();
		ViewNaver.instance.posterMenuItemCreator.addPosterMenuItems(this, posterSelection, popup);
		popup.addSeparator();

		popup.add(new JMenuItem(new AbstractAction("Cancel") {
			public void actionPerformed(ActionEvent e) {
				popup.setVisible(false);
			}
		}));

		browser.addBrowserListener(new BrowserListener() {
			public boolean beforeNavigate(final String url) {
				if(url.startsWith("comment:")) {
					int artId = Integer.valueOf(url.substring("comment:".length()));
					selectedArticle = compositeThread.articleList.getArticle(compositeThread.articleList.getArticleIndexByArticleID(artId));
					
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {
							posterSelection.setCurrentPoster(new Poster(selectedArticle.author, selectedArticle.country));
							
							Point mousePoint = MouseInfo.getPointerInfo().getLocation();
							Point compPoint = browser.getComponent().getLocationOnScreen();

							popup.show(browser.getComponent(), mousePoint.x - compPoint.x, mousePoint.y - compPoint.y);
						}
					});

					SwingUtilities.invokeLater(new Runnable() {				
						public void run() {
							postArticleView.setSelectedArticle(selectedArticle);
							replyArticleWindow.setSelectedArticle(selectedArticle);

							if(ViewNaver.instance.naverSession != null 
									&& ViewNaver.instance.naverSession.getUserName().equals(selectedArticle.author)
									&& selectedArticle.country.equals(Country.JAPAN)) {
								deleteArticleMenu.setEnabled(true);
							} else {
								deleteArticleMenu.setEnabled(false);
							}
						}
					});
				} else {
					SwingUtilities.invokeLater(new Runnable() {	
						public void run() {
							new OpenURLCommand(ThreadView.this, url, false).run();
						}
					});
				}

				return false;
			}
		});
	}

	public void setClientContent(TabContent content) {
		clientContent = (ThreadContent)content;
		CompositeThread newWebThreadContents = clientContent.target;

		if(compositeThread != null) {
			updateThread(newWebThreadContents);
		} else {
			compositeThread = newWebThreadContents;
			postArticleView.compositeThread = compositeThread;
			replyArticleWindow.replyArticleView.compositeThread = compositeThread;

			browser.beginDocWriting();
			browser.writeDocHtml(threadFormatter.formatThreadContent(compositeThread));
			browser.writeDocHtml(threadFormatter.formatThreadContentFooter(compositeThread));
//			browser.writeDocHtml(threadFormatter.formatArticleFooter(webThreadContents));
//			browser.insertBodyHtml("comment:-1", threadFormatter.formatArticleList(webThreadContents));
//			try { Thread.sleep(3000); } catch(Exception e) {}
			browser.writeDocHtml(threadFormatter.formatArticleList(compositeThread));
			browser.writeDocHtml(threadFormatter.formatArticleFooter(compositeThread));
			browser.endDocWriting();
		}
	}

	private void updateThread() {
		if(replyArticleWindow.isVisible()) replyArticleWindow.setVisible(false);
		
		CompositeThread newThread = ViewNaver.instance.cache.getCompositeThread(compositeThread.boardName, compositeThread.thread.nid, true);
		if(newThread != null) updateThread(newThread);
	}

	private void updateThread(CompositeThread newThread) {
		browser.replaceBodyHtml("thread:header", threadFormatter.formatThreadHeader(newThread));
		
		if(!compositeThread.contents.equals(newThread.contents)) {
			compositeThread.contents = newThread.contents;

			browser.replaceBodyHtml("thread:content", ViewNaver.instance.threadDecorator.decorate(newThread.contents));
		}

		compositeThread.articleList.merge(newThread.articleList);
		ViewNaver.instance.cache.putCompositeThread(compositeThread);
		ViewNaver.instance.threadStorage.storeThread(compositeThread);

		int lastVisibleSno = -1; // Ōɕ\X̃O[vID
		
		for(int i=0; i<compositeThread.articleList.getArticleCount(); i++) {
			Article art = compositeThread.articleList.getArticle(i);

			FilterType filterType = ViewNaver.instance.config.filterConfig.filters.get(new Poster(art.author, art.country));
			if(filterType == null) filterType = FilterType.NOAction;
			
			boolean isFavoritePerson = ViewNaver.instance.config.favoritePersonConfig.persons.contains(new Poster(art.author, art.country));

			int prevId = -1; // ÕXID

			if(i > 0) {
				prevId = compositeThread.articleList.getArticle(i-1).articleId;
			}

			if(art.isNew) {
				// VKɎ擾X̏ꍇAHTMLɒǉ
				String articleHtml = threadFormatter.formatArticle(lastVisibleSno, art, filterType, isFavoritePerson);
				browser.insertBodyHtml("comment:" + prevId, articleHtml);
			} else {
				// X̏ꍇ
				if(art.prevIsNew || art.isDeleted) {
					// OVKꍇA܂̓X폜ꂽꍇAHTML̑ύX
					browser.replaceBodyHtml("comment:" + art.articleId, 
							threadFormatter.formatInnerArticle(lastVisibleSno, art, filterType, isFavoritePerson));
				}
			}

			if(!filterType.equals(FilterType.Hidden)) {
				lastVisibleSno = art.sno;
			}
		}
	}

	@Override public void refreshContent() {
		// now printing...
	}
}
