/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.decorator;

public class EmbeddedMovieDecorator implements ContentsDecorator{
	public EmbeddedMovieDecorator() {}

	public String getExplain() {
		return "Enjoy KoreaߍޓpScriptScript";
	}

	public String decorate(String s) {
		return walkMovie(s, new MovieWalker() {
			public String walk(String contents, int prefixStart, int suffixStart, int prefixLength, int suffixLength) {
				return contents.substring(prefixStart + prefixLength, suffixStart);
			}
		});
	}

	public static interface MovieWalker {
		public String walk(String contents, int prefixStart, int suffixStart, int prefixLength, int suffixLength);
	};
	
	public static String walkMovie(String contents, MovieWalker walker) {
		String prefix = "<script language='javascript'>var multi_url=\"";
		String suffix = "\";</script><script src='/tbbs/file/multi_upload.js'></script>";
		
		int prefixLength = prefix.length();
		int suffixLength = suffix.length();

		int pos = 0;

		for(;;) {
			int prefixStart = contents.indexOf(prefix, pos);
	
			if(prefixStart == -1) break;
	
			int suffixStart = contents.indexOf(suffix, prefixStart);
	
			if(suffixStart == -1) break;
	
//			contents = walker.walk(contents, prefixStart, suffixStart, prefixLength, suffixLength);
			String replaced = walker.walk(contents, prefixStart, suffixStart, prefixLength, suffixLength);
			
			contents = 
				contents.substring(0, prefixStart-1) 
				+ replaced
				+ contents.substring(suffixStart + suffixLength);
 
			pos = prefixStart + replaced.length();
		}

		return contents;
	}
}
