/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.format;

import java.io.*;
import java.text.*;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.*;

public class DefaultFormatter {
	private String SPAN = ViewNaver.instance.getBrowserFactory().SPAN;
	private String HR = ViewNaver.instance.getBrowserFactory().HR;

	public DefaultFormatter() {}

	private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");
/*
	public String getInitialThreadHtml() {
		return "<html><head>"
		+ "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf8\">"
		//+"<style type=\"text/css\">BODY, TH, TD { font-family: 'MS UI Gothic'; }</style>"
		//+ "<link rel=\"stylesheet\" type=\"text/css\" href=\"./cache/enjoykorea.css\">"
		//+ "<link rel=\"stylesheet\" type=\"text/css\" href=\"./cache/layout.css\">"
		+ "<base href=\"http://bbs.enjoykorea.jp/\">"
		+ "</head><body></body></html>";
	}
*/
	public String formatThreadHeader(CompositeThread compositeThread) {
		NThread thread = compositeThread.thread;

		String urlString = 
			"http://bbs.enjoykorea.jp/tbbs/read.php?board_id=" + compositeThread.boardName +  "&nid=" + thread.nid;
		
		return thread.country.toHtml() + " "
			+ "<b>" + thread.poster + "</b> "
			+ thread.title + " "
			+ df.format(thread.createDate) +" "
			+ "<a href=\"" + urlString + "\">URL</a><br>"
			+ "{:" + thread.viewNum + " ";

	}
	
	public String formatThreadContent(CompositeThread compositeThread) {
		return  "<html><head>"
				+ "<meta http-equiv=\"Content-Type\" content=\"text/html\">"
				+ "<base href=\"http://bbs.enjoykorea.jp/\">"
				+ "<style> "
				+ "A.DEF:link, A.DEF:visited, A.DEF:active { color: black; border-width: 1px; text-decoration: none; }"
				+ "A.DEF:hover { color: gray; border-width: 1px; text-decoration: none; }"
				+ "</style>"
				+ "</head><body>"
				+ "<" + SPAN + " id=\"thread:header\">" + formatThreadHeader(compositeThread) + "</" + SPAN + ">"
				+ HR
				+ "<table><tr><td>"
				+ "<" + SPAN + " id=\"thread:content\">" + ViewNaver.instance.threadDecorator.decorate(compositeThread.contents) + "</" + SPAN + ">";
	}
	
	public String formatThreadContentFooter(CompositeThread compositeThread) {
		return "</td></tr></table>"
			+ "<font size=-1>"
			+ "<" + SPAN + " id=\"comment:-1\"></" + SPAN + ">";
	}
	
	public String formatArticleFooter(CompositeThread compositeThread) {
		return "</font>"
			+ "</body></html>";
	}

	public String formatArticleList(CompositeThread compositeThread) {
		StringWriter writer = new StringWriter();
		PrintWriter out = new PrintWriter(writer);

		ArticleList articles = compositeThread.articleList;

		int lastVisibleSno = -1;

		for(int i=0; i<articles.getArticleCount(); i++) {
			Article art = articles.getArticle(i);

			Poster poster = new Poster(art.author, art.country);
			
			FilterType filterType = ViewNaver.instance.config.filterConfig.filters.get(poster);
			if(filterType == null) filterType = FilterType.NOAction;

			boolean isFavoritePerson = ViewNaver.instance.config.favoritePersonConfig.persons.contains(poster);
			
			String articleContent = formatArticle(lastVisibleSno,art, filterType, isFavoritePerson);
			
			if(!filterType.equals(FilterType.Hidden)) {
				lastVisibleSno = art.sno;
			}
			
			out.println(articleContent);
		}

		out.close();
		
		return writer.toString();
	}
	
	public String formatPerson(String poster, boolean isFavoritePerson) {
		if(isFavoritePerson) {
			return ViewNaver.instance.config.favoritePersonConfig.startTag
			+ poster
			+ ViewNaver.instance.config.favoritePersonConfig.endTag;
		} else {
			return poster;
		}
	}
	
	public String formatInnerArticle(int lastVisibleSno, Article art,FilterType filterType, boolean isFavoritePerson) {
		if(filterType.equals(FilterType.Hidden)) return "";

		StringWriter writer = new StringWriter();
		PrintWriter out = new PrintWriter(writer);

		if(lastVisibleSno != art.sno) {
			out.print(HR);
		} else {
			out.print("<br>");
		}

		if(art.isReply) {
			out.print("&nbsp;&nbsp;");
		}

//		out.print("<a href=\"comment:" + art.articleId + "\"></a>");

		out.print(df.format(art.postDate) + " ");

		if(filterType.equals(FilterType.NOAction)) {
			out.print(art.country.toHtml() + " ");
			
			String start = "";
			String end = "";
			
			if(art.isDeleted) {
				start = "<s>";
				end = "</s>";
			}

			if(art.isNew) {
				start = start + "<b>";
				end = "</b>" + end;
			}

//			out.print("<" + SPAN + " id=\"poster:" + art.articleId + "\">" 
//					+ start + formatPerson(art.author, isFavoritePerson) + end + "</" + SPAN + "> ");

			out.print("<a class=\"DEF\" href=\"comment:" + art.articleId + "\""
//					+ " style = \"A:link, A:visited, A:active { color: black; border-width: 1px; text-decoration: none; } A:hover { color: gray; border-width: 1px; text-decoration: none; }\""
					+ ">" 
					+ start + formatPerson(art.author, isFavoritePerson) + end + "</a> ");

			out.print(ViewNaver.instance.articleDecorator.decorate(art.content));
		} else {
			out.print("(̨ς) ");
		}

		out.print("<br>");
		out.close();

		return writer.toString();
	}

	public String formatArticle(int lastVisibleSno, Article art, FilterType filterType, boolean isFavoritePerson) {
		String artText;
		
		if(filterType.equals(FilterType.Hidden)) {
			artText = "";
		} else {
			artText = formatInnerArticle(lastVisibleSno, art, filterType, isFavoritePerson);
		}

		return "<" + SPAN + " id=\"comment:" + art.articleId + "\">" +  artText + "</" + SPAN + ">";
	}
}
