/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.model;

import java.util.*;
import com.aibonware.viewnaver.*;

public class GoyakuJiten {
	private Vector<Goyaku> goyakus = new Vector<Goyaku>();
	private String SPAN = ViewNaver.instance.getBrowserFactory().SPAN;

	public GoyakuJiten() {}

	public void addGoyaku(Goyaku goyaku) {
		goyakus.addElement(goyaku);
	}

	private class ReplaceInfo implements Comparable<ReplaceInfo> {
		public int pos;
		public final Goyaku goyaku;
		
		public ReplaceInfo(int pos, Goyaku goyaku) {
			this.pos = pos;
			this.goyaku = goyaku;
		}

		public int compareTo(ReplaceInfo o) {
			if(this.pos != o.pos) return o.pos - this.pos;
			return o.goyaku.word.length() - this.goyaku.word.length();
		}
	}

	public String replaceGoyaku(String src) {
		Vector<ReplaceInfo> replaces = new Vector<ReplaceInfo>();
		
		for(int i=0; i<goyakus.size(); i++) {
			Goyaku goyaku = goyakus.elementAt(i);
			
			int pos = src.indexOf(goyaku.word);

			if(pos >= 0) {
				src = src.substring(0, pos) 
					+ src.substring(pos+goyaku.word.length());

				for(int j=0; j<replaces.size(); j++) {
					ReplaceInfo prevrep = replaces.elementAt(j);
					if(prevrep.pos > pos) {
						prevrep.pos -= goyaku.word.length();
					}
				}

				replaces.addElement(new ReplaceInfo(pos, goyaku));
			}
		}

//		Collections.sort(replaces);

		for(int i=0; i<replaces.size(); i++) {
			ReplaceInfo rep = replaces.elementAt(i);

			String exp = "<" + SPAN + " style=\"border-bottom:1px dotted\" title=\"" 
				+ "y" + rep.goyaku.word + "z" + rep.goyaku.explain + "\"><font color=\"green\">" 
				+ rep.goyaku.word 
				+  "</font></" + SPAN + ">";
			
			src = src.substring(0, rep.pos) 
				+ exp
				+ src.substring(rep.pos);
			
			for(int j=i+1; j<replaces.size(); j++) {
				ReplaceInfo nextrep = replaces.elementAt(j);
				if(nextrep.pos > rep.pos) {
					nextrep.pos += exp.length();
				}
			}
		}

		return src;
	}

	public void replaceGoyaku(ArticleList articles) {
		for(int i=0; i<articles.getArticleCount(); i++) {
			Article art = articles.getArticle(i);
			if(art.country.equals(Country.KOREA)) art.content = replaceGoyaku(art.content);
		}
	}
	
	public void sort() {
		Collections.sort(goyakus);
	}
}
