/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.net;

import java.io.*;
import com.aibonware.viewnaver.model.*;

public class AnonymousSession implements NaverSession {
	private final String userName;
	
	public AnonymousSession(String userName) {
		this.userName = userName;
	}

	public BufferedReader open(String url) throws NetException {
		throw new NotLoginException();
	}

	public InputStream openStream(String url) throws NetException {
		throw new NotLoginException();
	}

	public BufferedReader open(String url, String encoding) throws NetException {
		throw new NotLoginException();
	}

	public void login(String loginPassword) throws NetException {
		throw new NotLoginException();
	}

	public void logout() throws NetException {
		throw new NotLoginException();
	}

	public boolean nowLogin() {
		return false;
	}

	public void postArticle(String rawBoardName, int nid,
			String htmlContent) throws NetException {
				throw new NotLoginException();
			}

	public void replyArticle(String rawBoardName, int nid,
			String htmlContent, int sno) throws NetException {
				throw new NotLoginException();
			}

	public void deleteArticle(String rawBoardName, int nid,
			int articleId) throws NetException {
				throw new NotLoginException();
			}

	public int postThread(String boardName, String title,
			String content) throws NetException {
				throw new NotLoginException();
			}

	public void replyThread(String boardName, String title,
			String content, int nid, int sno) throws NetException {
				throw new NotLoginException();
			}

	public void modifyThread(String boardName, String title,
			String content, int nid) throws NetException {
				throw new NotLoginException();
			}

	public void deleteThread(String boardName, int nid)
			throws NetException {
				throw new NotLoginException();
			}

	public void sendMessage(String receiver, Country country,
			String messageText, boolean saveServer) throws NetException {
				throw new NotLoginException();
			}

	public void saveReceivedMessage(int[] messageIdList)
			throws NetException {
				throw new NotLoginException();
			}

	public void saveSentMessage(int[] messageIdList)
			throws NetException {
				throw new NotLoginException();
			}

	public void deleteReceivedMessage(int[] messageIdList)
			throws NetException {
				throw new NotLoginException();
			}

	public void deleteSentMessage(int[] messageIdList)
			throws NetException {
				throw new NotLoginException();
			}

	public void denyMessage(String sender, Country country)
			throws NetException {
				throw new NotLoginException();
			}

	public void cancelDenyList(int nidA[]) throws NetException {
		throw new NotLoginException();
	}

	public String getUserName() {
		return userName;
	}
	
	public Country getCountry() {
		return Country.JAPAN;
	}
}
