/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.parser;

import java.io.*;
import java.util.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.model.*;

public class DenyListParser {
	String urlString;
	
	public DenyListParser(String urlString) {
		this.urlString = urlString;
	}
	
	public Vector<DenyEntry> parse() throws NetException, ParsingException {
		BufferedReader reader = ViewNaver.instance.naverSession.open(urlString, "UTF8");

		Vector<DenyEntry> result = parse(reader);
		
		try {
			reader.close();
		} catch(IOException e) {
			throw new RuntimeException("URLN[Ys", e);
		}
		
		return result;
	}

	public Vector<DenyEntry> parse(BufferedReader reader) throws ParsingException, NetException  {
		ParsingContext ct = new ParsingContext(reader);
		Vector<DenyEntry> denyList = new Vector<DenyEntry>();

		try {
			ct.seek("<!-- List -->");

			for(;;) {
				if(!ct.seek("nidA[]", "<!-- //List -->")) break;
				String nidText = ct.cut("value='", "'");

				ct.seek("ico_message02.gif");

				String countryText = ct.cut("http://static.naver.com/enjoyjapan/tbbs/img_09/ico_", ".gif");
				String receiver = ct.cut(">", "</td>").trim();

				int nid = Integer.parseInt(nidText);
				
				Country country;
				
				if(countryText.equals("jpn")) {
					country = Country.JAPAN;
				} else if(countryText.equals("kor")) {
					country = Country.KOREA;
				} else {
					country = Country.UNKNOWN;
				}
				
				DenyEntry deny = new DenyEntry(receiver, country, nid);
				
				denyList.addElement(deny);
			}

			return denyList;
		} catch(NumberFormatException e) {
			throw new ParsingException(e, ct.text.toString());
		}
	}
}
