/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.parser;

import java.io.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.net.*;

public class GoyakuJitenParser {
	public String urlString;
	
	public GoyakuJitenParser(String urlString) {
		this.urlString = urlString;
	}

	public GoyakuJiten parse() throws NetException, ParsingException {
		BufferedReader reader = ViewNaver.instance.naverSession.open(urlString, "MS932");

		GoyakuJiten result =  parse(reader);

		result.sort();

		try {
			reader.close();
		} catch(IOException e) {
			throw new RuntimeException("URLN[Ys", e);
		}
		
		return result;
	}

	public GoyakuJiten parse(BufferedReader reader) throws ParsingException, NetException  {
		GoyakuJiten goyakuList = new GoyakuJiten();
		ParsingContext ct = new ParsingContext(reader);

		ct.seek("<!==</td>");

		for(;;) {
			if(!ct.seek("<b>y", "#omake")) break;

			String line = ct.cut(null, "<br>");
			line = line.replace("\n", " ");

			int wordEnd = line.indexOf("&#");

			wordEnd--;
			if(wordEnd < 0) wordEnd = line.indexOf("z");
			
			String word = line.substring(0, wordEnd);
			String explain = line.substring(line.indexOf("</b>") + "</b>".length()).trim();

			for(;;) {
				int refStart = explain.indexOf("&#");
				if(refStart == -1) break;
				
				int refEnd = explain.indexOf(";", refStart);
				
				int refCode = Integer.parseInt(explain.substring(refStart + "&#".length(), refEnd));
				
				explain = explain.substring(0, refStart)
					+ (char)refCode
					+ explain.substring(refEnd + ";".length());
			}
			
//			System.out.println(word + " : " + explain);
			
			goyakuList.addGoyaku(new Goyaku(word, ViewNaver.strToHtml(explain)));
		}

		return goyakuList;
	}
}
