/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.parser;

import java.io.*;

//import org.apache.xerces.xni.parser.*;
//import org.apache.xerces.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;
import javax.xml.parsers.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.net.*;

public class IDJitenParser {
	public String urlString;

	public IDJitenParser(String urlString) {
		this.urlString = urlString;
	}

	public IDJitenList parse() throws NetException, ParsingException {
		InputStream reader = ViewNaver.instance.naverSession.openStream(urlString);

		IDJitenList result = parse(reader);
		
		try {
			reader.close();
		} catch(IOException e) {
			throw new RuntimeException("URLN[Ys", e);
		}
		
		return result;
	}

	public IDJitenList parse(InputStream reader) throws ParsingException, NetException  {
		try {
			IDJitenList list = new IDJitenList();
	
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = dbfactory.newDocumentBuilder();
			Document doc = builder.parse(reader);

			Element root = doc.getDocumentElement();

			NodeList persons = root.getChildNodes();

			for(int i=0; i<persons.getLength(); i++) {
				Node personNode = persons.item(i);

				if(!personNode.getNodeName().equals("Person")) continue;
				Element personElem = (Element)personNode;

				String country = personElem.getAttribute("Country");
				String name = personElem.getAttribute("Name");
				String content = ((Element)personElem.getElementsByTagName("Content").item(0)).getTextContent();
				content = ViewNaver.htmlToStr(content);
				NodeList aliases =  personElem.getElementsByTagName("Alias");
				
				while(content.charAt(0) == '\n') content = content.substring(1);
				
				Poster person = new Poster(name, Country.strToCountry(country));
				
				list.addID(person, content);
				
				for(int j=0; j<aliases.getLength(); j++) {
					String aliaseName = ((Element)aliases.item(j)).getAttribute("Name");
					list.addID(new Poster(aliaseName, Country.strToCountry(country)), content);
				}
			}

			return list;

		} catch(ParserConfigurationException e) {
			ViewNaver.err(e);
			return null;
		} catch(SAXException e) {
			ViewNaver.err(e);
			return null;
		} catch(IOException e) {
			ViewNaver.err(e);
			return null;
		}
	}
}
