/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.parser;

import java.io.*;
import java.util.*;
import java.text.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.model.*;

public class MessageListParser {
	String urlString;
	
	public MessageListParser(String urlString) {
		this.urlString = urlString;
	}
	
	public MessageTitleList parse() throws NetException, ParsingException {
		BufferedReader reader = ViewNaver.instance.naverSession.open(urlString, "UTF8");

		MessageTitleList result = parse(reader);
		
		try {
			reader.close();
		} catch(IOException e) {
			throw new RuntimeException("URLN[Ys", e);
		}
		
		return result;
	}

	private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

	public MessageTitleList parse(BufferedReader reader) throws ParsingException, NetException  {
		ParsingContext ct = new ParsingContext(reader);

		try {
			ct.seek("bZ[W:");
	
			// MEǐ擾
			String receivedMessageNumText = ct.cut("M", "");
			String preReceivedMessageNumText = ct.cut("", "");
			String sendMessageNumText = ct.cut("M", "");
	
			int receivedNum = Integer.parseInt(receivedMessageNumText.trim());
			int preReceivedNum = Integer.parseInt(preReceivedMessageNumText.trim());
			int sendNum = Integer.parseInt(sendMessageNumText.trim());
	
			MessageTitleList messages = new MessageTitleList(receivedNum, preReceivedNum, sendNum);
			
			ct.seek("<!-- List -->");
	
			// ebZ[W
			for(;;) {
				if(!ct.seek("<tr", "<!-- //List -->")) break;
				
				// ǎʁEۑ
				String preReceivedText = ct.cut(null, "checkbox");

				boolean received = !preReceivedText.contains("bold");
				boolean stored = preReceivedText.contains("background-color");
	
				// 
				ct.seek("http://static.naver.com/enjoyjapan/tbbs/img_09/ico_message" );

				String countryText = ct.cut("http://static.naver.com/enjoyjapan/tbbs/img_09/ico_", ".gif");
				Country country;
	
				if(countryText.equals("jpn")) {
					country = Country.JAPAN;
				} else if(countryText.equals("kor")) {
					country = Country.KOREA;
				} else {
					country = Country.UNKNOWN;
				}
	
				ct.seek(">");
				
				// M
				String person = ct.cut(null, "</td>").trim();
	
				// bZ[WID
				String messageIdText = ct.cut("_view.php?no=", "\">").trim();
				
				int messageId = Integer.parseInt(messageIdText);
	
				// bZ[W\
				String messageTitle = ct.cut(null, "</a>").trim();
				
				// 
				String dateText = ct.cut("gray04\">", "</td>");
				
				Date date = df.parse(dateText);
				
				MessageTitle message = new MessageTitle(
					person,
					country,
					received,
					messageId,
					messageTitle,
					date,
					stored);
				
				messages.addMessageTitle(message);
				
				ct.seek("</tr>");
			}
		
			return messages;
		} catch(NumberFormatException e) {
			throw new ParsingException(e, ct.text.toString());
		} catch(ParseException e) {
			throw new ParsingException(e, ct.text.toString());
		}
	}
}
