/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.movie;

import com.aibonware.viewnaver.server.*;
import com.aibonware.viewnaver.server.servlet.*;

import Acme.Serve.servlet.*;
import Acme.Serve.servlet.http.*;

public class MoviePlayServlet extends BaseServlet {
	@Override protected boolean isText() {
		return false;
	}

	@Override public String getName() {
		return "mplay";
	}

	public MoviePlayServlet() {}

	public static final String createUrl(UserSession user, int movieNo) {
		return "mplay?sid=" + user.sid + "&n=" + movieNo;
	}

	@Override public void dispContents(MiniServer server, UserSession user, HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) throws Exception {
		String sMovieNo = request.getParameter("n");
		int movieNo = Integer.parseInt(sMovieNo);

		Movie movie = user.movieCache.get(movieNo);
		
		if(movie == null || movie.worker.getStatus() != MovieWorker.STATUS_FINISH) {
			response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
			return;
		}
	
		response.setStatus(HttpServletResponse.SC_OK);
		response.setContentType(server.movieContentType);
		response.setContentLength(movie.contents.length);

		out.write(movie.contents);
	}
}
