/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.servlet;

import Acme.Serve.servlet.*;
import Acme.Serve.servlet.http.*;
import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.parser.*;
import com.aibonware.viewnaver.server.MiniServer;
import com.aibonware.viewnaver.server.UserSession;

public class BoardServlet extends BaseServlet {
	public BoardServlet() {}

	@Override public String getName() {
		return "board";
	}

	public static String createUrl(UserSession user, String boardName, int page) {
		String url = "board?sid=" + user.sid + "&b=" + boardName;
		if(page < 1) page = 1; 
		url = url + "&p=" + page;
		return url;
	}

	private void showTools(ServletOutputStream out, boolean header, UserSession user, String boardName, int pageNo) throws Exception {
		out.print(" <a href=\"main?sid=" + user.sid + "\"></a>");

		if(header) out.print("<a href=\"#bottom\"></a>");
		else out.print("<a href=\"#top\"></a>");

		if(pageNo > 1) out.print("<a href=\"" + createUrl(user, boardName, pageNo-1) + "\">O</a>");
		out.print("<a href=\"" + createUrl(user, boardName, pageNo+1) + "\"></a>");	
		out.print("<a href=\"" + WriteNewThreadServlet.createUrl(user, boardName) + "\"></a>");
		out.print(" <a href=\"logout?sid=" + user.sid + "\">۸ޱ</a>");
	}

	@Override public void dispContents(MiniServer server, UserSession user, HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) throws Exception {
		String boardName = request.getParameter("b");
		String sPage = request.getParameter("p");
		int pageNo = Integer.parseInt(sPage);

		out.println("<a name=\"top\">");
		out.print("P" + pageNo);
		showTools(out, true, user, boardName, pageNo);
		out.println("<hr>");
		
		BoardTitle boardTitle = ViewNaver.instance.boardTitles.getBoardTitle(boardName);

		BoardParser parser = new BoardParser(ViewNaver.instance.web.getBoardPageUrl(boardName, pageNo));
		Board board = parser.parse(boardTitle.boardName, boardTitle.dispName, boardTitle.boardType, pageNo);

		for(int i=0; i<board.getThreadCount(); i++) {
			NThread thread = board.getTitle(i);
			
			String baseTitle = thread.title;

			if(baseTitle.trim().length() == 0) {
				baseTitle = "<i>(󗓂)</i>";
			}

			String title = "";
			for(int j=0; j<thread.depth; j++) title = title + "@";
			if(thread.depth > 0) title = title + "";
			title = title + baseTitle;

			out.print("<a href=\"thread?sid=" + user.sid + "&b=" + board.boardName + "&t=" + thread.nid + "&s=0\">+</a> ");
			out.print(title + " " + thread.country.toHtml() + " <b>" + thread.poster + "</b> ");
			out.println("[" + thread.articleNum + "]<hr>");
		}

		showTools(out, false, user, boardName, pageNo);
		out.println("<a name=\"bottom\">");
	}
}
