/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.servlet;


import java.text.*;
import java.util.TreeMap;

import Acme.*;
import Acme.Serve.servlet.*;
import Acme.Serve.servlet.http.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.server.MiniServer;
import com.aibonware.viewnaver.server.UserSession;

public class PostNewThreadServlet extends BaseServlet {
	private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");

	public PostNewThreadServlet() {}

	@Override public String getName() {
		return "pnthread";
	}

	@Override public void dispContents(MiniServer server, UserSession user, HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) throws Exception {
		TreeMap<String, String> params = getPostParams(request);

		String boardName = params.get("b");
		String title = params.get("title");
		String content = params.get("ThreadContent");

		title = Utils.urlDecoder(title);
		content = Utils.urlDecoder(content);

		out.println("e..<br>");
		out.flush();

		int nid = ViewNaver.instance.naverSession.postThread(
				boardName, title, ViewNaver.strToHtml(content).replaceAll("\\n", "<br>"));

		out.println(".<br>");
		
		out.println("<a href=\"" + ThreadServlet.createUrl(user, boardName, nid, 0, false) + "\">V</a>");
	}
}
