/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.servlet;


import java.text.*;

import Acme.Serve.servlet.*;
import Acme.Serve.servlet.http.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.server.MiniServer;
import com.aibonware.viewnaver.server.UserSession;

public class WriteReplyThreadServlet extends BaseServlet {
	private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");

	public WriteReplyThreadServlet() {}

	@Override public String getName() {
		return "wrthread";
	}

	private static int createSno(String dispId) {
		if(dispId == null) return -1;

		int delim = dispId.indexOf('-');
		if(delim >= 0) dispId = dispId.substring(0, delim);
		dispId = dispId.trim();
		
		if(dispId.equals("")) return -1;
		
		try {
			return Integer.parseInt(dispId);
		} catch(NumberFormatException e) {
			return -1;
		}
	}

	public static String createUrl(UserSession user, CompositeThread composite) {
		return "wrthread?sid=" 
		+ user.sid + "&b=" 
		+ composite.boardName 
		+ "&nid=" + composite.thread.nid
		+ "&sno=" + createSno(composite.thread.dispId);
	}

	@Override public void dispContents(MiniServer server, UserSession user, HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) throws Exception {
		String boardName = request.getParameter("b");
		String nid = request.getParameter("nid");
		String sno = request.getParameter("sno");

		out.println("ԐMځF<br>");
		out.println("<form method=post action=\"prthread?sid=" + user.sid + "\">");
        out.println("<input type=\"hidden\" name=\"b\" value=\"" + boardName + "\">");
        out.println("<input type=\"hidden\" name=\"nid\" value=\"" + nid + "\">");
        out.println("<input type=\"hidden\" name=\"sno\" value=\"" + sno + "\">");
        out.println(": <input type=\"text\" name=\"title\"><br>");
		out.println(": <textarea name=ThreadContent></textarea><br>");
		out.println("<input type=submit value=\"e\">");
		out.println("</form>");
	}
}
