/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.view;


import java.util.*;

public class Navigator {
	public final String name;

	private Navigator parent = null;
	private Vector<Navigator> children = new Vector<Navigator>();
	private Vector<NavigationListener> listeners = new Vector<NavigationListener>();
	
	public Navigator(String name) {
		this.name = name;
	}

	public void navigate() {}
	public void select() {}
	
	public Navigator getParent() {
		return parent;
	}
	
	public int getChildCount() {
		return children.size();
	}
	
	public Navigator getChildAt(int index) {
		return children.elementAt(index);
	}

	public void addChild(Navigator child) {
		children.addElement(child);
		child.parent = this;

		for(int i=0; i<listeners.size(); i++) {
			listeners.elementAt(i).childAdded(child);
		}
	}

	public void removeChild(Navigator child) {
		children.removeElement(child);
		for(int i=0; i<listeners.size(); i++) {
			listeners.elementAt(i).childAdded(child);
		}
	}
	
	public int getIndex(Navigator child) {
		return children.indexOf(child);
	}
	
	public void addListener(NavigationListener listener) {
		listeners.addElement(listener);
	}
	
	public void removeListener(NavigationListener listener) {
		listeners.removeElement(listener);
	}
}
