/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.view;

import java.awt.*;

import javax.swing.*;

import com.aibonware.viewnaver.component.*;
import com.aibonware.viewnaver.model.*;

@SuppressWarnings("serial")
public class SearchRemoteThreadView extends PagePanel {
	JTextField keywordText;
	JEnumRadioButton<SearchType> searchTitleRadio;
	JEnumRadioButton<SearchType> searchPosterRadio;
	JEnumRadioButton<SearchType> searchNoRadio;
	ButtonGroup group = new ButtonGroup();
	BoardTitle board;

	public SearchRemoteThreadView(BoardTitle board, String keyword, SearchType searchType) {
		this.board = board;

		keywordText = new JTextField();
		keywordText.setMaximumSize(new Dimension(1000, 20));

		searchTitleRadio = new JEnumRadioButton<SearchType>("^CgŌ", SearchType.SearchByTitle);
		searchPosterRadio = new JEnumRadioButton<SearchType>("eҖŌ", SearchType.SearchByPoster);
		searchNoRadio = new JEnumRadioButton<SearchType>("XbhԍŌ", SearchType.SearchByNo);

		group.add(searchPosterRadio);
		group.add(searchTitleRadio);
		group.add(searchNoRadio);

		if(searchType != null) {
			if(searchType.equals(SearchType.SearchByTitle)) searchTitleRadio.setSelected(true);
			if(searchType.equals(SearchType.SearchByPoster)) searchPosterRadio.setSelected(true);
			if(searchType.equals(SearchType.SearchByNo)) searchNoRadio.setSelected(true);
		} else {
			searchPosterRadio.setSelected(true);
		}

		if(keyword != null) keywordText.setText(keyword);
		

		addLine("L[[hF", glue(keywordText), "\n",
				searchPosterRadio, "\n",
				searchTitleRadio, "\n",
				searchNoRadio);
	}

	public SearchType getSearchType() {
		return ((EnumButtonModel<SearchType>)group.getSelection()).enumValue;
	}

	public String getKeyword() {
		return keywordText.getText();
	}
}
