/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.view;

import java.awt.*;

import javax.swing.*;

import com.aibonware.viewnaver.model.*;

@SuppressWarnings("serial")
public class SendMessageView extends JPanel {
	public JComboBox countryList = new JComboBox();
	public JTextField receiverField = new JTextField();
	public JTextArea messageArea = new JTextArea();
	public JCheckBox storedCheck = new JCheckBox("T[oɉiۊ");

	public SendMessageView() {
		super(new BorderLayout());

		countryList.addItem("");
		countryList.addItem("");

		Box header = new Box(BoxLayout.LINE_AXIS);

		header.add(countryList);
		header.add(receiverField);

		add(header, BorderLayout.NORTH);
		add(new JScrollPane(messageArea), BorderLayout.CENTER);
		add(storedCheck, BorderLayout.CENTER);
	}
	
	public void setMessage(Country country, String receiver, String replyText) {
		if(country.equals(Country.JAPAN)) countryList.setSelectedItem("");
		else countryList.setSelectedItem("");
		
		receiverField.setText(receiver);
	
		messageArea.setText(replyText);
		storedCheck.setSelected(false);
	}
}
