/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.window;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.config.*;

@SuppressWarnings("serial")
public class ConfigDialog extends JDialog implements ChildWindow {
	private Config resultConfig;
	private ConfigView view;

	public ConfigDialog(JFrame parentFrame, Config config) {
		super(parentFrame, "ݒ", true);
		setLayout(new BorderLayout());
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);

/*
		JTabbedPane tabs = new JTabbedPane();

//		final NetworkConfigView networkConfigView = new NetworkConfigView(config);
		final ArticleTemplateView articleTemplateView = new ArticleTemplateView(config);
		
//		tabs.add("ڑ", networkConfigView);
		tabs.add("X`", articleTemplateView);
*/
		resultConfig = (Config)config.cloneTree();
		view = new ConfigView(resultConfig);

		JButton okButton = new JButton("OK");
		JButton cancelButton = new JButton("Cancel");
		Box buttonBox = new Box(BoxLayout.LINE_AXIS);

		buttonBox.add(Box.createGlue());
		buttonBox.add(okButton);
		buttonBox.add(cancelButton);

		add(view, BorderLayout.CENTER);
//		add(tabs, BorderLayout.CENTER);
		add(buttonBox, BorderLayout.SOUTH);

//		pack();
		setBounds(200, 200, 400, 250);

		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ConfigDialog.this.dispose();
			}
		});

		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				try {
					view.applyConfig();
					resultConfig.validateTree();
					
					ViewNaver.instance.config = resultConfig;
					resultConfig.fireConfigureChanged();
					
					ConfigDialog.this.dispose();

				} catch(ConfigException e) {
					JOptionPane.showConfirmDialog(ConfigDialog.this, e.getMessage());
				}
				
//				networkConfigView.write(ConfigDialog.this.config);
//				articleTemplateView.write(ConfigDialog.this.config);
			}
		});
		
		ViewNaver.instance.childWindowActivator.addChildWindow(this);
	}

}
