/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.window;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.component.*;
import com.aibonware.viewnaver.config.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.task.*;

@SuppressWarnings("serial")
public class LoginDialog extends JFrame {
	public boolean confirmed = false;
	public String userName = "";
	public String password = "";
	public JTextField userNameText;
	JPasswordField passwordText;
	
	NetworkConfig networkConfig = (NetworkConfig)ViewNaver.instance.config.network.cloneThis();
	ConfigItemView networkConfigView = ViewNaver.instance.config.network.getView();

	JButton notLoginButton = new JButton("OCɋN");
	JButton okButton = new JButton("OK");
	JButton cancelButton = new JButton("Cancel");

	AbstractAction okAction = new AbstractAction("OK") {
		public void actionPerformed(ActionEvent event) {
			try {
				networkConfigView.applyConfig();
				ViewNaver.instance.config.network = networkConfig;
			} catch(ConfigException e) {
				ViewNaver.println(e.getMessage());
				return;
			}
			
			userName = userNameText.getText();
			password = new String(passwordText.getPassword());

			TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getLoginFlow();


			taskFlow.addStatusReceiver(new DefaultTaskStatusReceiver(
					taskFlow, okButton, okAction, cancelButton, notLoginButton));

			taskFlow.execute(new WorkerTask() {
				public void exec() {	
					try {
						ViewNaver.println("OCJn..");
						NaverSession naverSession = new LoginSession(userName);
						naverSession.login(password);
						ViewNaver.instance.naverSession = naverSession;
						ViewNaver.println("OCIB");
						confirmed = true;

						taskFlow.execute(new GUITask() {
							public void exec() {
								LoginDialog.this.dispose();
							}
						});
						
					} catch(NetException e) {
						ViewNaver.println("OCɎs܂F");
						ViewNaver.println(e.getMessage());
					}
				}
			});
		}
	};

	public LoginDialog(JFrame parentFrame, JTextArea logText, final Config config) {
		super("Login");

		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		
		networkConfigView.setConfig(networkConfig);

		networkConfigView.setBorder(new BevelBorder(BevelBorder.RAISED));

		PagePanel accountPage = new PagePanel();
		accountPage.setBorder(new BevelBorder(BevelBorder.RAISED));

		userNameText = new JTextField();
		passwordText = new JPasswordField();

		accountPage.addLine("[UF \t", PagePanel.glue(userNameText));
		accountPage.addLine("pX[h: \t", PagePanel.glue(passwordText));

		ViewNaver.instance.deftex.plus(userNameText);
		ViewNaver.instance.deftex.plus(passwordText);
		
		notLoginButton.setEnabled(false);

		okButton.setEnabled(false);

		PagePanel buttonBox = new PagePanel(notLoginButton, PagePanel.glue(), okButton, cancelButton);

		PagePanel panel = new PagePanel(
				PagePanel.glue(networkConfigView), "\n", 
				PagePanel.glue(accountPage), "\n",
				PagePanel.glue(buttonBox));

		if(logText != null) {
			JScrollPane logPanel = new JScrollPane(
					logText, 
					ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, 
					ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
			
			panel.addLine(logPanel);
		}

		add(panel, BorderLayout.CENTER);

		setBounds(200, 200, 400, 300);

		this.getRootPane().setDefaultButton(okButton);

		DocumentListener buttonActivator = new DocumentListener() {
			private void textChanged() {
				boolean emptyUserName = (userNameText.getText().length() == 0);
				boolean emptyPassword = (passwordText.getPassword().length == 0);

				boolean okButtonEnabled = !emptyUserName && !emptyPassword;
				boolean anonButtonEnabled =!emptyUserName;
				
				if(okButtonEnabled != okButton.isEnabled()) {
					okButton.setEnabled(okButtonEnabled);
				} 
				
				if(anonButtonEnabled != notLoginButton.isEnabled()) {
					notLoginButton.setEnabled(anonButtonEnabled);
				}
			}
			
			public void insertUpdate(DocumentEvent e) {
				textChanged();
			}

			public void removeUpdate(DocumentEvent e) {
				textChanged();
			}

			public void changedUpdate(DocumentEvent e) {
				textChanged();
			}
		};
		
		userNameText.getDocument().addDocumentListener(buttonActivator);
		passwordText.getDocument().addDocumentListener(buttonActivator);

		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				confirmed = false;
				LoginDialog.this.dispose();
			}
		});

		okButton.setAction(okAction);
		
		notLoginButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int result = JOptionPane.showConfirmDialog(
						LoginDialog.this, 
						"OCviewNVRN܂B\n"
						+ "Enjoy Korea֐ڑ邱Ƃ͂ł܂B"
						+ "[J\[Xւ̃ANZX݂̂\łB\n"
						+ "ȂA[Uɂ͐O͂ĂB",
						"mF",
						JOptionPane.OK_CANCEL_OPTION);
	
				if(result == JOptionPane.OK_OPTION) {
					userName = userNameText.getText();
					ViewNaver.instance.naverSession = new AnonymousSession(userName);
					confirmed = true;

					LoginDialog.this.dispose();
				}
			}
		});
		
		addWindowListener(new WindowAdapter() {
			public void windowOpened(WindowEvent e) {
				userNameText.requestFocusInWindow();
			}
		});
	}
}
