/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.window;

import java.io.*;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.command.*;
import com.aibonware.viewnaver.component.StatusBar;
import com.aibonware.viewnaver.config.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.content.board.*;
import com.aibonware.viewnaver.content.message.*;
import com.aibonware.viewnaver.content.favorite.*;
import com.aibonware.viewnaver.content.localsearch.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.view.*;
import com.aibonware.viewnaver.parser.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.storage.*;
import com.aibonware.viewnaver.task.*;

@SuppressWarnings("serial")
public class MainWindow extends JFrame implements ConfigUser {
	public LogView logView;
	JSplitPane vertPane;
	JSplitPane horiPane;
	public JToggleButton showChildWindowButton;
	public BoardTitlesGroup textBoardTitlesGroup;
	public BoardTitlesGroup imageBoardTitlesGroup;
	public StatusBar statusBar;

	public NavigationView navigationView;
	public TabContainerView containerView;
	
	public TabContainer container;
	
	public MainWindowConfig mainWindowConfig;
	
	private Navigator createNavigator(BoardTitle boardTitle) {
		return new BoardNavigator(boardTitle);
	}

	private Navigator createNavigator(BoardTitlesGroup boardGroup) {
		Navigator navigator = new Navigator(boardGroup.groupName);
		
		for(int i=0; i<boardGroup.getBoardCount(); i++) {
			navigator.addChild(createNavigator(boardGroup.getBoardTitle(i)));
		}
		
		return navigator;
	}

	private static class MessageNavigators extends Navigator {
		public MessageNavigators() {
			super("bZ[W");

			addChild(new ReceivedMessageNavigator());
			addChild(new SentMessageNavigator());
			addChild(new DenyListNavigator());
		}
	}
	
	private static class MainNavigators extends Navigator {
		public MainNavigators() {
			super("C");
			
			addChild(new FavoriteNavigator());
		}
	}

	public MainWindow() {
		setTitle("viewNVR beta version");

		setJMenuBar(createMenuBar());

		Navigator rootNavigator = new Navigator("");

		rootNavigator.addChild(new MainNavigators());
		rootNavigator.addChild(new MessageNavigators());
		
		textBoardTitlesGroup = new BoardTitlesGroup("text", ViewNaver.instance.boardTitles.getBoardTitles(BoardType.Text));
		imageBoardTitlesGroup = new BoardTitlesGroup("image", ViewNaver.instance.boardTitles.getBoardTitles(BoardType.Image));

		rootNavigator.addChild(createNavigator(textBoardTitlesGroup));
		rootNavigator.addChild(createNavigator(imageBoardTitlesGroup));

		logView = new LogView();
		
		navigationView = new NavigationView();
		navigationView.setNavigator(rootNavigator);

		containerView = new TabContainerView();
		container = new TabContainer(ViewNaver.instance.defaultCategoryComparator);
		containerView.setClientContainer(container);
		
		containerView.addFactory(BoardContent.class, new BoardViewFactory());
		containerView.addFactory(ReceivedMessageContent.class, new ReceivedMessageContentViewFactory());
		containerView.addFactory(SentMessageContent.class, new SentMessageContentViewFactory());
		containerView.addFactory(DenyListContent.class, new DenyListContentViewFactory());
		containerView.addFactory(FoundThreadsContent.class, new FoundThreadsViewFactory());
		containerView.addFactory(FavoriteContent.class, new FavoriteContentViewFactory());
		containerView.addFactory(LocalFoundContent.class, new LocalFoundContentViewFactory());

		DefaultTabContentOrder comparator = ViewNaver.instance.defaultCategoryComparator;
		
		comparator.add(ReceivedMessageContent.class);
		comparator.add(SentMessageContent.class);
		comparator.add(DenyListContent.class);
		comparator.add(FavoriteContent.class);
		comparator.add(BoardContent.class);
		comparator.add(FoundThreadsContent.class);
		comparator.add(LocalFoundContent.class);

//		boardTitleTreeView = new BoardTitlesTreeView(textBoardTitlesGroup, imageBoardTitlesGroup);

		showChildWindowButton = new JToggleButton("qʕ\");
	
		JToolBar toolbar = new JToolBar();
		toolbar.add(showChildWindowButton);
		toolbar.setFloatable(false);
		
		vertPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, true);
		horiPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true);

		vertPane.setTopComponent(horiPane);
		vertPane.setBottomComponent(new JScrollPane(logView));
		vertPane.setDividerSize(4);
		vertPane.setResizeWeight(1);

		horiPane.setLeftComponent(new JScrollPane(navigationView));
//		horiPane.setRightComponent(boardListView);
		horiPane.setRightComponent(containerView);
		horiPane.setDividerSize(4);
		horiPane.setDividerLocation(130);

		JPanel panel = new JPanel(new BorderLayout());
		
		statusBar = new StatusBar(this);
		
		panel.add(toolbar, BorderLayout.NORTH);
		panel.add(vertPane, BorderLayout.CENTER);

		this.add(panel, BorderLayout.CENTER);
		this.add(statusBar, BorderLayout.SOUTH);

		//this.add(vertPane);

		addWindowListener(new WindowAdapter() {
			@Override public void windowClosing(WindowEvent e) {
				ViewNaver.instance.exit();
			}
		});
/*
		addWindowFocusListener(new WindowAdapter() {
			@Override public void windowGainedFocus(WindowEvent e) {
				if(ViewNaver.instance.threadWindow.isVisible()) {
					ViewNaver.instance.threadWindow.setVisible(false);
				}
			}
		});
*/
		showChildWindowButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(ViewNaver.instance.mainWindow.showChildWindowButton.isSelected()) {
					ViewNaver.instance.childWindowActivator.activateChildren();
				}
			}
		});

		mainWindowConfig = new MainWindowConfig();
		
		ViewNaver.instance.config.addChild(mainWindowConfig);
		ViewNaver.instance.config.addConfigUser(this);
		
		addComponentListener(new ComponentAdapter() {
			private void updateBounds() {
				Rectangle r = getBounds();

				mainWindowConfig.left = r.x;
				mainWindowConfig.top = r.y;
				mainWindowConfig.width = r.width;
				mainWindowConfig.height = r.height;
			}

			public void componentMoved(ComponentEvent e) {
				updateBounds();
			}

			public void componentResized(ComponentEvent e) {
				updateBounds();
			}
		});
	}

	public void configChanged(Config config) {
		if((getExtendedState() & (ICONIFIED | MAXIMIZED_BOTH)) != 0) return;

		mainWindowConfig = (MainWindowConfig)config.getAncestor("MainWindow");
		Rectangle r = new Rectangle(mainWindowConfig.left, mainWindowConfig.top, mainWindowConfig.width, mainWindowConfig.height);

		if(!r.equals(getBounds())) setBounds(r);
	}

	private boolean firstVisible = true;
	
	public void setVisible(boolean visible) {
		super.setVisible(visible);

		if(visible && firstVisible) {
			vertPane.setDividerLocation(0.8);
			firstVisible = false;
		} 
	}

	private static class MenuAction extends AbstractAction {
		public MenuAction(String name, int mnemonic) {
			super(name);
			putValue(MNEMONIC_KEY, mnemonic);
		}

		public void actionPerformed(ActionEvent e) {}
	}

	private JMenuBar createMenuBar() {
		JMenuBar bar = new JMenuBar();
		
		JMenu file = new JMenu(new MenuAction("File", KeyEvent.VK_F));
		JMenu edit = new JMenu(new MenuAction("Edit", KeyEvent.VK_E));
		JMenu tool = new JMenu(new MenuAction("Tool", KeyEvent.VK_T));
		JMenu devel = new JMenu(new MenuAction("Devel", KeyEvent.VK_D));

		JMenuItem test = new JMenuItem(new MenuAction("test", KeyEvent.VK_T) {
			@Override public void actionPerformed(ActionEvent e) {
				try {
/*
 						String cmdline[] = {
							"C:\\work\\ffmtest\\ffmpeg.exe",
							"-y",
							"-i",
							"C:\\work\\ffmtest\\test2.flv",
							"-b",
							"2000",
							"-ar",
							"8000",
							"-ac",
							"1",
							"-s",
							"128x96",
							"-r",
							"10",
							"-f",
							"3gp",
							"-"};
*/
				
					String cmdline = 
							"C:\\work\\ffmtest\\ffmpeg.exe -y -i C:\\work\\ffmtest\\test2.flv -b 2000 -ar 8000 -ac 1 -s 128x96 -r 10 -f 3gp -";

					
					Process process = Runtime.getRuntime().exec(cmdline);
					final BufferedInputStream stderr = new BufferedInputStream(process.getErrorStream());
					final BufferedInputStream stdin = new BufferedInputStream(process.getInputStream());

					new Thread() {
						@Override public void run() {
							try {
								BufferedReader errreader = new BufferedReader(new InputStreamReader(stderr));
								String line;
	
								while((line = errreader.readLine()) != null) {
									ViewNaver.println(line);
								}
								
								stderr.close();
							} catch(Exception e) {
								ViewNaver.err(e);
							}
						}
					}.start();
					
					new Thread() {
						@Override public void run() {
							try {
								BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream("c:\\work\\ffmtest\\vnout.3gp"));
								byte buf[] = new byte[1000];
								
								for(;;) {
									int len = stdin.read(buf);
									if(len == -1) break;
									out.write(buf, 0, len);
								}
								
								out.close();
								stdin.close();
							} catch(Exception e) {
								ViewNaver.err(e);
							}
						}
					}.start();
					
					process.waitFor();
					
					ViewNaver.println("exit code: " + process.exitValue());
					
					
					
				} catch(Exception ex) {
					ViewNaver.err(ex);
				}
			}
		});

		JMenuItem miniServer = new JMenuItem(new MenuAction("Remote Control...", KeyEvent.VK_R) {
			@Override public void actionPerformed(ActionEvent e) {
				if(!ViewNaver.instance.naverSession.nowLogin()) {
					ViewNaver.println("OCĂ܂B");
					return;
				}
				
				if(ViewNaver.instance.server != null) {
					ViewNaver.println("Remote Control͊ɗLɂȂĂ܂B");
					return;
				}
				
				MiniServerDialog dialog = new MiniServerDialog(MainWindow.this);
				dialog.setVisible(true);
			}
		});
		
		
		
		JMenuItem exit = new JMenuItem(new MenuAction("Exit", KeyEvent.VK_X) {
			@Override public void actionPerformed(ActionEvent e) {
				ViewNaver.instance.exit();
			}
		});

		JMenuItem config = new JMenuItem(new MenuAction("ݒ...", KeyEvent.VK_C) {
			@Override public void actionPerformed(ActionEvent e) {
				ConfigDialog dialog = new ConfigDialog(MainWindow.this, ViewNaver.instance.config);
				dialog.setVisible(true);
			}
		});
/*
		JMenuItem searchOnlineThread = new JMenuItem(new MenuAction("Search Remote Thread...", KeyEvent.VK_S) {
			@Override public void actionPerformed(ActionEvent e) {
				Navigator navigator = navigationView.getSelectedNavigator();
				if(navigator == null || !(navigator instanceof BoardNavigator)) {
					ViewNaver.println("c[ʂŔIĂ");
					return;
				}
				
				SearchRemoteThreadDialog dialog = new SearchRemoteThreadDialog(MainWindow.this, ((BoardNavigator)navigator).boardTitle);
				dialog.setVisible(true);
			}
		});
*/
		JMenuItem searchLocalThread = new JMenuItem(new MenuAction("O...", KeyEvent.VK_S) {
			@Override public void actionPerformed(ActionEvent e) {
				SearchLocalThreadDialog dialog = new SearchLocalThreadDialog(MainWindow.this);
				dialog.setVisible(true);
			}
		});

		JMenuItem readGoyaku = new JMenuItem(new MenuAction("󎫓T̓ǂݍ(einsamkeit)", KeyEvent.VK_G) {
			@Override public void actionPerformed(ActionEvent event) {
				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.createNewFlow();

				taskFlow.execute(new WorkerTask() {
					public void exec() {	
						try {
							ViewNaver.println("󎫓T̓ǍJn...");
							
							GoyakuJitenParser parser = new GoyakuJitenParser("http://einsamkeit.hp.infoseek.co.jp/naver_goyaku.htm");
							ViewNaver.instance.goyakuList = parser.parse();
							
							ViewNaver.println("󎫓T̓ǂݍݏIB");
											
						} catch(NetException e) {
							ViewNaver.err(e);
						} catch(ParsingException e) {
							ViewNaver.err(e);
						}
					}
				});
			}
		});

		JMenuItem readIDJiten = new JMenuItem(new MenuAction("IDT̓ǂݍ(enjoyid)", KeyEvent.VK_0) {
			@Override public void actionPerformed(ActionEvent event) {
				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.createNewFlow();
				
				taskFlow.execute(new WorkerTask() {
					public void exec() {	
						try {
							ViewNaver.println("IDT̓ǍJn...");
							
							IDJitenParser parser = new IDJitenParser("http://enjoyid.net/xml?mode=main");
							ViewNaver.instance.idJiten = parser.parse();
							
							ViewNaver.println("IDT̓ǂݍݏIB");
											
						} catch(NetException e) {
							ViewNaver.err(e);
						} catch(ParsingException e) {
							ViewNaver.err(e);
						}
					}
				});
			}
		});
		
		JMenuItem wikiGoyaku = new JMenuItem("󎫓T̓ǂݍ(uwakina-honeypie)");
		JMenuItem wikiIDJiten = new JMenuItem("IDT̓ǂݍ(uwakina-honeypie)");
		JMenuItem links = new JMenuItem("NW̓ǂݍ(Naver2ch)");

		wikiGoyaku.setEnabled(false);
		wikiIDJiten.setEnabled(false);
		links.setEnabled(false);
		
		JMenuItem openUrl = new JMenuItem(new MenuAction("Open Url...", KeyEvent.VK_O) {
			@Override public void actionPerformed(ActionEvent event) {
				String urlText = JOptionPane.showInputDialog(
						ViewNaver.instance.mainWindow, 
						"Xbh܂͔URL͂ĂF");

				ViewNaver.instance.childWindowActivator.setClosingChild(new Object());

				if(urlText == null) return;
				
				if(urlText == null || urlText.trim().equals("")) {
					ViewNaver.println("URLłB");
					return;
				}

				new OpenURLCommand(MainWindow.this, urlText, true).run();
			}
		});
		
		JMenuItem save = new JMenuItem(new MenuAction("Save...", KeyEvent.VK_S) {
			@Override public void actionPerformed(ActionEvent event) {
				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.createNewFlow();
				
				taskFlow.execute(new WorkerTask() {
					public void exec() {
						try {
							ViewNaver.println("XbhOo͊Jn...");
							int num = ViewNaver.instance.threadStorage.flash();
							ViewNaver.println("XbhOo͏I(" + num + "Xbhۑ)");
						} catch(StorageException e) {
							ViewNaver.err(e);
						}

						ViewNaver.instance.config.saveFile("config.xml");
					}
				});
			}
		});

/*
		JMenuItem login = new JMenuItem(new MenuAction("Login...", KeyEvent.VK_L) {
			@Override public void actionPerformed(ActionEvent event) {
				if(ViewNaver.instance.naverSession != null) {
					ViewNaver.println("ɃOCς݂łB");
					return;
				}

				LoginDialog loginDialog = new LoginDialog(MainWindow.this, null);
				loginDialog.setVisible(true);
			}
		});

		JMenuItem logout = new JMenuItem(new MenuAction("Logout", KeyEvent.VK_O) {
			@Override public void actionPerformed(ActionEvent event) {
				if(ViewNaver.instance.naverSession == null) {
					ViewNaver.println("OCĂ܂B");
					return;
				}

				ViewNaver.asyncWorkerExec(new Runnable() {
					public void run() {
						try {
							ViewNaver.println("OAEgJn..");
							ViewNaver.instance.naverSession.logout();
							ViewNaver.instance.naverSession = null;
							ViewNaver.println("OAEgIB");
						} catch(NetException e) {
							ViewNaver.err(e);
						}
					}
				});
			}
		});

		file.add(login);
		file.add(logout);
*/

		bar.add(file);
		bar.add(edit);
		bar.add(tool);
		bar.add(devel);

		file.add(openUrl);
		file.addSeparator();
		file.add(save);
		file.addSeparator();
		file.add(exit);

//		edit.add(searchOnlineThread);
		edit.add(searchLocalThread);
		tool.add(readGoyaku);
		tool.add(readIDJiten);
		tool.add(wikiGoyaku);
		tool.add(wikiIDJiten);
		tool.add(links);

		tool.addSeparator();
		tool.add(config);
		devel.add(test);
		devel.add(miniServer);

		return bar;
	}
}

