/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.window;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.content.board.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.task.*;
import com.aibonware.viewnaver.view.*;

@SuppressWarnings("serial")
public class SearchRemoteThreadDialog extends JDialog implements ChildWindow {
	SearchRemoteThreadView searchView;

	public SearchRemoteThreadDialog(JFrame parentFrame, final BoardTitle boardTitle) {
		this(parentFrame, boardTitle, null, null);
	}
	
	public SearchRemoteThreadDialog(JFrame parentFrame, final BoardTitle boardTitle, String keyword, SearchType searchType) {
		super(parentFrame, boardTitle.dispName + "Xbh", true);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);

		searchView = new SearchRemoteThreadView(boardTitle, keyword, searchType);

		JButton okButton = new JButton("OK");
		JButton cancelButton = new JButton("Cancel");
		Box buttonBox = new Box(BoxLayout.LINE_AXIS);

		buttonBox.add(Box.createGlue());
		buttonBox.add(okButton);
		buttonBox.add(cancelButton);

		add(searchView, BorderLayout.CENTER);
		add(buttonBox, BorderLayout.SOUTH);

		this.getRootPane().setDefaultButton(okButton);
		
		pack();
		setBounds(200, 200, 400, 200);

		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SearchRemoteThreadDialog.this.dispose();
			}
		});

		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				final SearchType searchType = searchView.getSearchType();
				final String keyword = searchView.getKeyword();
				SearchRemoteThreadDialog.this.dispose();

				TabContainerView containerView = ViewNaver.instance.mainWindow.containerView;
				TabContentCategory category = FoundThreadsContent.getConstantCategory(boardTitle, searchType, keyword);

				containerView.update(category);
/*

				final SearchType searchType = searchView.getSearchType();
				final String keyword = searchView.getKeyword();
				SearchRemoteThreadDialog.this.dispose();
				
				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getSearchRemoteThreadFlow(boardTitle.boardName, searchType, keyword);

				taskFlow.execute(new WorkerTask() {
					public void exec() {
						final FoundThreads threads = searchType.execSearch(
								boardTitle.boardName, 
								boardTitle.dispName, 
								boardTitle.boardType, 
								keyword, 
								1);

						taskFlow.execute(new GUITask() {
							public void exec() {
								
								if(threads == null) return;

								final FoundThreadsContent content = new FoundThreadsContent(threads);

								TabContent oldContent = ViewNaver.instance.mainWindow.container.getContentByCategory(
									FoundThreadsContent.getConstantCategory(boardTitle, searchType, keyword));

								if(oldContent != null) {
									ViewNaver.instance.mainWindow.container.replace(oldContent, content);
								} else {
									ViewNaver.instance.mainWindow.container.addContent(content);
								}
								
//								replace(FoundThreadsContent.this, );
								 ViewNaver.instance.mainWindow.containerView.activate(content.getCategory());
							}
						});
					}
				});
				
*/
			
			}
		});
		ViewNaver.instance.childWindowActivator.addChildWindow(this);
	}
}
