/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.window;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.component.StatusBar;
import com.aibonware.viewnaver.config.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.content.thread.*;

@SuppressWarnings("serial")
public class ThreadWindow extends JDialog implements ConfigUser, ChildWindow {
	public TabContainerView threadListView;
	public TabContainer container;
	public ThreadWindowConfig threadWindowConfig;
	
	public ThreadWindow(JFrame parent) {
		super(parent);
		setTitle("thread");
		setLayout(new BorderLayout());
		
		addWindowListener(new WindowAdapter() {
			@Override public void windowClosing(WindowEvent e) {
				setVisible(false);
			}
		});
/*
		addComponentListener(new ComponentAdapter() {
			@Override public void componentHidden(ComponentEvent e) {
				ViewNaver.instance.mainWindow.showThreadWindowButton.setSelected(false);
			}
			
			@Override public void componentShown(ComponentEvent e) {
				ViewNaver.instance.mainWindow.showThreadWindowButton.setSelected(true);
			}
		});
*/
		container = new TabContainer(ViewNaver.instance.defaultCategoryComparator);
		threadListView = new TabContainerView();
		threadListView.setClientContainer(container);

		threadListView.addFactory(ThreadContent.class, new ThreadViewFactory());

		add(threadListView, BorderLayout.CENTER);
		add(new StatusBar(this), BorderLayout.SOUTH);

		threadWindowConfig = new ThreadWindowConfig();
		
		ViewNaver.instance.config.addChild(threadWindowConfig);
		ViewNaver.instance.config.addConfigUser(this);

		addComponentListener(new ComponentAdapter() {
			private void updteBounds() {
				Rectangle r = getBounds();

				threadWindowConfig.left = r.x;
				threadWindowConfig.top = r.y;
				threadWindowConfig.width = r.width;
				threadWindowConfig.height = r.height;
			}
			
			public void componentMoved(ComponentEvent e) {
				updteBounds();
			}

			public void componentResized(ComponentEvent e) {
				updteBounds();
			}
		});
		
		ViewNaver.instance.childWindowActivator.addChildWindow(this);
	}

	public void configChanged(Config config) {
		threadWindowConfig = (ThreadWindowConfig)config.getAncestor("ThreadWindow");
		Rectangle r = new Rectangle(threadWindowConfig.left, threadWindowConfig.top, threadWindowConfig.width, threadWindowConfig.height);

		if(!r.equals(getBounds())) setBounds(r);
	}
}
